/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring;

import com.pingidentity.monitoring.HeartbeatMBeanAttribute;
import com.pingidentity.monitoring.MonitoringService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class MonitoringServiceImpl
implements MonitoringService {
    private final Logger log = LogManager.getLogger(MonitoringServiceImpl.class);
    private static final String STATISTICS_WINDOW_SECS = "StatisticsWindowSecs";
    private static final String STATISTICS_PERCENTILES_LIST = "StatisticsPercentilesList";
    private static final String HEARTBEAT_MBEAN_ATTRIBUTES = "HeartbeatMBeanAttributes";
    private static final String THREAD_POOL_EXHAUSTION_CONFIG = "ThreadPoolExhaustionConfiguration";
    private static final String HISTOGRAM_BUFFER_LENGTH = "HistogramBufferLength";
    private static final String HISTOGRAM_PERCENTILE_PRECISION = "HistogramPercentilePrecision";
    private static final String ENABLE_ADAPTER_METRICS = "EnableAdapterMetrics";
    private static final String ENABLE_CONNECTION_METRICS = "EnableConnectionMetrics";
    private static final String ENABLE_BULKHEAD_METRICS = "EnableBulkheadMetrics";
    private static final String ENABLE_AUDIT_LOGGING_METRICS = "EnableAuditLoggingMetrics";
    private ConfigStore cfg = ConfigStoreFarm.getConfig("com.pingidentity.monitoring.MonitoringService");

    @Override
    public long getStatisticsWindowSecs() {
        return this.cfg.getLongValue(STATISTICS_WINDOW_SECS, 300L);
    }

    @Override
    public double[] getStatisticsPercentilesArray() {
        String percentileString = this.cfg.getStringValue(STATISTICS_PERCENTILES_LIST, "90");
        try {
            return Arrays.stream(StringUtils.split((String)percentileString, (String)",")).mapToDouble(d -> Math.floor(Double.parseDouble(d.trim()) * 100.0) / 10000.0).toArray();
        }
        catch (NumberFormatException ex) {
            this.log.error("Unable to parse statistics percentile values for 'StatisticsPercentilesList'.", (Throwable)ex);
            return new double[]{0.9};
        }
    }

    @Override
    public List<HeartbeatMBeanAttribute> getHeartbeatMBeanAttributes() {
        ArrayList<HeartbeatMBeanAttribute> result = new ArrayList<HeartbeatMBeanAttribute>();
        for (Map.Entry entry : this.cfg.getMapValue(HEARTBEAT_MBEAN_ATTRIBUTES, Collections.emptyMap()).entrySet()) {
            String entryValue = (String)entry.getValue();
            String[] parts = entryValue.split("\\|");
            if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty()) {
                this.log.warn("Invalid format for heartbeat MBean attribute: " + entryValue);
                continue;
            }
            result.add(new HeartbeatMBeanAttribute((String)entry.getKey(), parts[0], parts[1]));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Map<String, String> getThreadPoolExhaustionConfig() {
        return Collections.unmodifiableMap(this.cfg.getMapValue(THREAD_POOL_EXHAUSTION_CONFIG, Collections.emptyMap()));
    }

    @Override
    public int getHistogramBufferLength() {
        return this.cfg.getIntValue(HISTOGRAM_BUFFER_LENGTH, 2);
    }

    @Override
    public int getHistogramPercentilePrecision() {
        return this.cfg.getIntValue(HISTOGRAM_PERCENTILE_PRECISION, 1);
    }

    @Override
    public boolean isAdapterMetricsEnabled() {
        return this.cfg.getBooleanValue(ENABLE_ADAPTER_METRICS, true);
    }

    @Override
    public boolean isConnectionMetricsEnabled() {
        return this.cfg.getBooleanValue(ENABLE_CONNECTION_METRICS, true);
    }

    @Override
    public boolean isBulkheadMetricsEnabled() {
        return this.cfg.getBooleanValue(ENABLE_BULKHEAD_METRICS, true);
    }

    @Override
    public boolean isAuditLoggingMetricsEnabled() {
        return this.cfg.getBooleanValue(ENABLE_AUDIT_LOGGING_METRICS, true);
    }
}

