/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring;

import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.monitoring.MonitoringService;
import com.pingidentity.monitoring.ThreadDumpLogger;
import com.pingidentity.monitoring.ThreadPoolExhaustionConfig;
import com.pingidentity.monitoring.ThreadPoolExhaustionOperator;
import com.pingidentity.monitoring.Util;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.util.license.Synchronizer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ThreadPoolExhaustionService {
    private static final Log log = LogFactory.getLog(ThreadPoolExhaustionService.class);
    private static final ThreadPoolExhaustionService instance = new ThreadPoolExhaustionService();
    private static final String THREAD_DUMP_GENERATED = "THREAD_DUMP_GENERATED";
    private static final String IP_ADDR = "IP_ADDR";
    private static final String MBEAN_NAME = "MBEAN_NAME";
    private static final String MBEAN_ATTRIBUTE = "MBEAN_ATTRIBUTE";
    private static final String OPERATOR = "OPERATOR";
    private static final String THRESHOLD = "THRESHOLD";
    private static final String SAMPLES = "SAMPLES";
    private static final String SAMPLE_INTERVAL_SECONDS = "SAMPLE_INTERVAL_SECONDS";
    private static final String MBEAN_ATTRIBUTE_CURRENT_VALUE = "MBEAN_ATTRIBUTE_CURRENT_VALUE";
    private final Mediator mediator = MgmtFactory.getMediator();
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final MonitoringService monitoringService = MgmtFactory.getMonitoringService();
    private ThreadPoolExhaustionConfig threadPoolExhaustionConfig;
    private Timer timer;
    private int samples;
    private boolean threadDumpGenerated = false;
    private Instant quietPeriodEndsAt = Instant.MIN;
    private boolean log4j2Upgraded = false;

    public static ThreadPoolExhaustionService getInstance() {
        return instance;
    }

    public void start() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.log4j2Upgraded = this.checkLog4j2Upgraded();
        this.threadPoolExhaustionConfig = new ThreadPoolExhaustionConfig(this.monitoringService.getThreadPoolExhaustionConfig());
        if (!this.threadPoolExhaustionConfig.isValidConfig()) {
            log.warn((Object)"Thread Pool Exhaustion configuration is invalid, monitoring timer task is not scheduled");
            return;
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    ThreadPoolExhaustionService.this.checkThreadPoolExhaustion();
                }
                catch (Throwable t) {
                    log.error((Object)"Unexpected error during check for thread exhaustion.", t);
                }
            }
        }, 0L, this.threadPoolExhaustionConfig.getSampleIntervalSeconds() * 1000L);
    }

    protected void checkThreadPoolExhaustion() {
        if (Instant.now().isBefore(this.quietPeriodEndsAt)) {
            log.trace((Object)"Skipping thread pool exhaustion check as the quiet period is in effect.");
            return;
        }
        log.trace((Object)"Performing thread pool exhaustion check.");
        String mBeanName = this.threadPoolExhaustionConfig.getMBeanName();
        String mBeanAttribute = this.threadPoolExhaustionConfig.getMBeanAttribute();
        double threshold = this.threadPoolExhaustionConfig.getThreshold();
        ThreadPoolExhaustionOperator operator = this.threadPoolExhaustionConfig.getOperator();
        try {
            double attributeValue;
            Object attribute = this.mBeanServer.getAttribute(new ObjectName(mBeanName), mBeanAttribute);
            if (attribute instanceof Number) {
                attributeValue = ((Number)attribute).doubleValue();
            } else if (attribute instanceof String) {
                try {
                    attributeValue = Double.parseDouble((String)attribute);
                }
                catch (NumberFormatException ex) {
                    log.warn((Object)("Unable to parse mBeanAttribute: " + mBeanAttribute + " String value as double."));
                    return;
                }
            } else {
                log.warn((Object)("Unable to parse mBeanAttribute: " + mBeanAttribute + " value as double."));
                return;
            }
            switch (operator) {
                case LESS_THAN: {
                    if (attributeValue < threshold) {
                        log.debug((Object)("Thread pool exhaustion threshold (" + threshold + ") breached: " + attributeValue));
                        --this.samples;
                        if (this.samples > 0) break;
                        this.alertAndGenerateThreadDump(attributeValue);
                        return;
                    }
                    this.samples = this.threadPoolExhaustionConfig.getSamples();
                    break;
                }
                case GREATER_THAN: {
                    if (attributeValue > threshold) {
                        log.debug((Object)("Thread pool exhaustion threshold (" + threshold + ") breached: " + attributeValue));
                        --this.samples;
                        if (this.samples > 0) break;
                        this.alertAndGenerateThreadDump(attributeValue);
                        return;
                    }
                    this.samples = this.threadPoolExhaustionConfig.getSamples();
                    break;
                }
            }
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            log.debug((Object)("Error occurred retrieving attribute, MBean=" + mBeanName + ", attribute=" + mBeanAttribute + ": " + ExceptionUtil.toStringWithCauses(e)));
        }
    }

    private void alertAndGenerateThreadDump(double attributeValue) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        if (settings.isEnableThreadPoolExhaustionNotification() && settings.getThreadPoolExhaustionThreadDump()) {
            this.threadDumpGenerated = true;
            String threadDump = Util.dumpThreads();
            String ipAddr = this.mediator.isStandalone() ? Synchronizer.getSynchronizer().getIP() : this.mediator.getClusterIpAddress();
            ThreadDumpLogger.log(threadDump, ipAddr);
        } else {
            this.threadDumpGenerated = false;
        }
        this.log(attributeValue);
        this.sendThreadPoolExhaustionEmail(attributeValue);
        this.samples = this.threadPoolExhaustionConfig.getSamples();
        this.quietPeriodEndsAt = Instant.now().plus(Duration.ofMinutes(this.threadPoolExhaustionConfig.getQuietPeriodMinutes()));
    }

    private void log(double attributeValue) {
        String logTemplate = this.getLogTemplate();
        HashMap<String, String> substitutionValuesMap = new HashMap<String, String>();
        if (this.mediator.isStandalone()) {
            substitutionValuesMap.put(IP_ADDR, Synchronizer.getSynchronizer().getIP());
        } else {
            substitutionValuesMap.put(IP_ADDR, this.mediator.getClusterIpAddress());
        }
        substitutionValuesMap.put(MBEAN_NAME, this.threadPoolExhaustionConfig.getMBeanName());
        substitutionValuesMap.put(MBEAN_ATTRIBUTE, this.threadPoolExhaustionConfig.getMBeanAttribute());
        substitutionValuesMap.put(OPERATOR, this.threadPoolExhaustionConfig.getOperator().toString());
        substitutionValuesMap.put(THRESHOLD, String.valueOf(this.threadPoolExhaustionConfig.getThreshold()));
        substitutionValuesMap.put(SAMPLES, String.valueOf(this.threadPoolExhaustionConfig.getSamples()));
        substitutionValuesMap.put(SAMPLE_INTERVAL_SECONDS, String.valueOf(this.threadPoolExhaustionConfig.getSampleIntervalSeconds()));
        substitutionValuesMap.put(MBEAN_ATTRIBUTE_CURRENT_VALUE, String.valueOf(attributeValue));
        String msg = Substituter.substituteValuesTolarateUnkownKey((String)logTemplate, substitutionValuesMap);
        log.warn((Object)msg);
    }

    private void sendThreadPoolExhaustionEmail(double attributeValue) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        if (settings.isEnableThreadPoolExhaustionNotification() && settings.getNotificationPublisherThreadPoolExhaustion() != null && settings.getThreadPoolExhaustionNotificationMode() != null && settings.getThreadPoolExhaustionNotificationMode().equals((Object)NotificationMode.NOTIFICATION_PUBLISHER)) {
            String emailTemplateFile = this.getEmailTemplateFile();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (this.mediator.isStandalone()) {
                params.put(IP_ADDR, Synchronizer.getSynchronizer().getIP());
            } else {
                params.put(IP_ADDR, this.mediator.getClusterIpAddress());
            }
            if (this.threadDumpGenerated) {
                params.put(THREAD_DUMP_GENERATED, true);
            }
            params.put(MBEAN_NAME, this.threadPoolExhaustionConfig.getMBeanName());
            params.put(MBEAN_ATTRIBUTE, this.threadPoolExhaustionConfig.getMBeanAttribute());
            params.put(OPERATOR, (Object)this.threadPoolExhaustionConfig.getOperator());
            params.put(THRESHOLD, String.valueOf(this.threadPoolExhaustionConfig.getThreshold()));
            params.put(SAMPLES, String.valueOf(this.threadPoolExhaustionConfig.getSamples()));
            params.put(SAMPLE_INTERVAL_SECONDS, String.valueOf(this.threadPoolExhaustionConfig.getSampleIntervalSeconds()));
            params.put(MBEAN_ATTRIBUTE_CURRENT_VALUE, String.valueOf(attributeValue));
            notificationSupportHelper.publishNotification(settings.getNotificationPublisherThreadPoolExhaustion(), emailTemplateFile, settings.getThreadPoolExhaustionTo(), params, NotificationEventType.THREAD_POOL_EXHAUSTION.toString());
        }
    }

    private String getEmailTemplateFile() {
        return "message-template-thread-pool-exhaustion.html";
    }

    private String getLogTemplate() {
        return "\n\tPingFederate thread pool usage on the server with IP address ${IP_ADDR} has breached the configured threshold.\n" + (this.threadDumpGenerated ? "\tA thread dump was generated.\n" : "") + "\tMBean Name: ${MBEAN_NAME}\n\tMBean Attribute: ${MBEAN_ATTRIBUTE}\n\tOperator: ${OPERATOR}\n\tThreshold: ${THRESHOLD}\n\tNumber of samples: ${SAMPLES}\n\tSample Interval (Seconds): ${SAMPLE_INTERVAL_SECONDS}\n\tCurrent value of ${MBEAN_ATTRIBUTE}: ${MBEAN_ATTRIBUTE_CURRENT_VALUE}";
    }

    private boolean checkLog4j2Upgraded() {
        File file = new File(MgmtFactory.getSysDirInfo().getConfigDirectory() + File.separator + "log4j2.xml");
        if (!file.exists()) {
            log.warn((Object)"log4j2.xml not found, could not determine if the file has necessary configuration for thread pool exhaustion thread dump.");
            return true;
        }
        try {
            DocumentBuilder builder = XmlBeansUtil.getDocumentBuilder();
            Document doc = builder.parse(file);
            XPath xPath = XPathFactory.newInstance().newXPath();
            if (this.checkLog4j2ContainsLogger(xPath, doc) && this.checkLog4j2ContainsAppender(xPath, doc)) {
                log.debug((Object)"log4j2.xml has been configured properly, thread pool exhaustion thread dump will be captured");
                return true;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            log.warn((Object)"Unexpected error scanning log4j2.xml, could not determine if the file has necessary configuration for thread pool exhaustion thread dump.", (Throwable)e);
            return true;
        }
        log.warn((Object)"Log4j2.xml is missing necessary configuration, thread pool exhaustion thread dump will not be captured.");
        return false;
    }

    private boolean checkLog4j2ContainsAppender(XPath xPath, Document doc) throws XPathExpressionException {
        NodeList nodes = (NodeList)xPath.evaluate("/Configuration/Appenders/RollingFile", doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String value;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node appender = attributes.getNamedItem("name");
            if (appender == null || !(value = appender.getNodeValue()).equals("ThreadDumpAppender")) continue;
            return true;
        }
        log.warn((Object)"Log4j2.xml is missing ThreadDumpAppender");
        return false;
    }

    private boolean checkLog4j2ContainsLogger(XPath xPath, Document doc) throws XPathExpressionException {
        NodeList nodes = (NodeList)xPath.evaluate("/Configuration/Loggers/AsyncLogger", doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String value;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node appender = attributes.getNamedItem("name");
            if (appender == null || !(value = appender.getNodeValue()).equals("ThreadDumpLogger")) continue;
            return true;
        }
        log.warn((Object)"Log4j2.xml is missing ThreadDumpLogger");
        return false;
    }

    public boolean isLog4j2Upgraded() {
        return this.log4j2Upgraded;
    }
}

