/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Util {
    public static String dumpThreads() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threads = bean.dumpAllThreads(true, true);
        return Stream.of(threads).map(Util::dumpThreadInfo).collect(Collectors.joining("\n"));
    }

    private static String dumpThreadInfo(ThreadInfo thread) {
        StringBuilder sb = new StringBuilder(String.format("\"%s\" #%s prio=0 tid=0x%x nid=NA %s%n", thread.getThreadName(), thread.getThreadId(), thread.getThreadId(), thread.getThreadState().toString().toLowerCase()));
        sb.append(String.format("   java.lang.Thread.State: %s%n", new Object[]{thread.getThreadState()}));
        LockInfo blockedLock = thread.getLockInfo();
        StackTraceElement[] s = thread.getStackTrace();
        MonitorInfo[] monitors = thread.getLockedMonitors();
        for (int i = 0; i < s.length; ++i) {
            StackTraceElement ste = s[i];
            sb.append(String.format("\tat %s%n", ste));
            if (i == 0 && blockedLock != null) {
                boolean parking = ste.isNativeMethod() && ste.getMethodName().equals("park");
                sb.append(String.format("\t- %s <0x%x> (a %s)%n", Util.blockedState(thread, blockedLock, parking), blockedLock.getIdentityHashCode(), blockedLock.getClassName()));
            }
            if (monitors == null) continue;
            MonitorInfo[] monitorInfoArray = monitors;
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo monitor = monitorInfoArray[j];
                if (monitor.getLockedStackDepth() != i) continue;
                sb.append(String.format("\t- locked <0x%x> (a %s)%n", monitor.getIdentityHashCode(), monitor.getClassName()));
            }
        }
        sb.append('\n');
        LockInfo[] synchronizers = thread.getLockedSynchronizers();
        if (synchronizers != null && synchronizers.length > 0) {
            sb.append("\n   Locked ownable synchronizers:\n");
            for (LockInfo synchronizer : synchronizers) {
                sb.append(String.format("\t- <0x%x> (a %s)%n", synchronizer.getIdentityHashCode(), synchronizer.getClassName()));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String blockedState(ThreadInfo thread, LockInfo blockedLock, boolean parking) {
        String state = blockedLock != null ? (thread.getThreadState() == Thread.State.BLOCKED ? "waiting to lock" : (parking ? "parking to wait for" : "waiting on")) : null;
        return state;
    }
}

