/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.elements.impl;

import com.pingidentity.pingcommons.monitoring.elements.MonitorElementBase;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.adminstate.SynchronizationState;

public class AdminConsole
extends MonitorElementBase {
    private static final String PREFIX = "admin.console";
    private static final String ROLE = "admin.console.role";
    private static final String ROLE_LAST_UPDATED = "admin.console.role.last.updated";
    private static final String SYNC_STATUS = "admin.console.sync.status";
    private static final String SYNC_TIMESTAMP = "admin.console.sync.timestamp";

    public Map<String, Object> getResults() {
        SynchronizationState syncState;
        AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (adminNodeConfigManager.getRole() != null) {
            result.put(ROLE, adminNodeConfigManager.getRole().name());
            Instant roleLastUpdated = adminNodeConfigManager.getRoleLastUpdateDate();
            if (roleLastUpdated != null) {
                result.put(ROLE_LAST_UPDATED, roleLastUpdated);
            }
        }
        if ((syncState = adminNodeConfigManager.getSyncState()) != null) {
            if (syncState.getConfigSyncStatus() != null) {
                result.put(SYNC_STATUS, syncState.getConfigSyncStatus().name());
            }
            if (syncState.getConfigSyncTimestamp() != null) {
                result.put(SYNC_TIMESTAMP, syncState.getConfigSyncTimestamp().toInstant());
            }
        }
        return result;
    }
}

