/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.elements.impl;

import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.monitoring.ConnectionPoolMetrics;
import com.pingidentity.monitoring.metrics.MeterManager;
import com.pingidentity.pingcommons.monitoring.elements.MonitorElementBase;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DataStores
extends MonitorElementBase {
    private static final MeterManager meterManager = MeterManager.getInstance();
    private static final DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();

    public Map<String, Object> getResults() {
        this.results.putAll(meterManager.getDataSourceResponseTimeStats());
        LinkedHashMap<String, Integer> dsConnPoolResults = new LinkedHashMap<String, Integer>();
        for (LdapDataSource ldapDataSource : dataSourceManager.getLdapDataSources()) {
            ConnectionPoolMetrics connectionPoolMetrics = LDAPUtil.getConnectionPoolMetrics(ldapDataSource.getId());
            if (connectionPoolMetrics == null) continue;
            dsConnPoolResults.put(String.format("ds.%s.%s.max.connections", new Object[]{ldapDataSource.getDSType(), ldapDataSource.getId()}), connectionPoolMetrics.getMaxPoolSize());
            dsConnPoolResults.put(String.format("ds.%s.%s.idle.connections", new Object[]{ldapDataSource.getDSType(), ldapDataSource.getId()}), connectionPoolMetrics.getIdleConnections());
            dsConnPoolResults.put(String.format("ds.%s.%s.min.connections", new Object[]{ldapDataSource.getDSType(), ldapDataSource.getId()}), connectionPoolMetrics.getMinConnections());
        }
        for (Map.Entry entry : dataSourceManager.getJdbcDataSourcesConnectionPoolMetrics().entrySet()) {
            dsConnPoolResults.put(String.format("ds.%s.%s.max.connections", DataSource.DSType.JDBC.getName(), entry.getKey()), ((ConnectionPoolMetrics)entry.getValue()).getMaxPoolSize());
            dsConnPoolResults.put(String.format("ds.%s.%s.active.connections", DataSource.DSType.JDBC.getName(), entry.getKey()), ((ConnectionPoolMetrics)entry.getValue()).getActiveConnections());
            dsConnPoolResults.put(String.format("ds.%s.%s.idle.connections", DataSource.DSType.JDBC.getName(), entry.getKey()), ((ConnectionPoolMetrics)entry.getValue()).getIdleConnections());
            dsConnPoolResults.put(String.format("ds.%s.%s.min.connections", DataSource.DSType.JDBC.getName(), entry.getKey()), ((ConnectionPoolMetrics)entry.getValue()).getMinConnections());
        }
        this.results.putAll(dsConnPoolResults);
        return this.results;
    }
}

