/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.elements.impl;

import com.pingidentity.monitoring.metrics.MeterManager;
import com.pingidentity.pingcommons.monitoring.elements.MonitorElementBase;
import java.util.Map;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.IdpSessionRegistry;
import org.sourceid.saml20.service.InterRequestStateMgmt;
import org.sourceid.saml20.service.SpSessionRegistry;
import org.sourceid.saml20.state.StateMgmtFactory;

public class RuntimeStateMaps
extends MonitorElementBase {
    private static final String baseATMTokenMapSizeJSONName = "atm.%s.token.map.size";
    private final MeterManager meterManager = MeterManager.getInstance();

    public Map<String, Object> getResults() {
        InterRequestStateMgmt map = StateMgmtFactory.getInterRequestStateMgmt();
        this.results.put("session.state.attribute.map.size", map.getAttributeMapSize());
        this.results.putAll(this.meterManager.getStats("session.state.attribute.map.purge.unexpired"));
        this.results.put("transaction.state.map.size", map.getTransactionStateMapSize());
        this.results.putAll(this.meterManager.getStats("transaction.state.map.purge.unexpired"));
        IdpSessionRegistry idpSessionRegistry = StateMgmtFactory.getIdpSessionRegistry();
        this.results.put("idp.session.registry.session.map.size", idpSessionRegistry.getSessionInfoMapSize());
        this.results.putAll(this.meterManager.getStats("idp.session.registry.session.map.purge.unexpired"));
        SpSessionRegistry spSessionRegistry = StateMgmtFactory.getSpSessionRegistry();
        this.results.put("sp.session.registry.session.map.size", spSessionRegistry.getSessionInfoMapSize());
        this.results.putAll(this.meterManager.getStats("sp.session.registry.session.map.purge.unexpired"));
        BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        Map<String, Integer> tokenMapSizes = bearerAccessTokenMgmtPluginManager.getTokenMapSizes();
        for (Map.Entry<String, Integer> entry : tokenMapSizes.entrySet()) {
            this.results.put(String.format(baseATMTokenMapSizeJSONName, entry.getKey()), entry.getValue());
        }
        return this.results;
    }
}

