/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.metrics;

import com.pingidentity.monitoring.MonitoringService;
import com.pingidentity.monitoring.metrics.MeterMapper;
import com.pingidentity.monitoring.metrics.TimerScope;
import com.pingidentity.monitoring.metrics.config.HeartbeatConfig;
import com.pingidentity.monitoring.metrics.config.HeartbeatMeterFilter;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class MeterManager {
    private static final Log log = LogFactory.getLog(MeterManager.class);
    private final MonitoringService monitoringService = MgmtFactory.getMonitoringService();
    private StepMeterRegistry heartbeatRegistry;
    private volatile Snapshots prevSnapshots = new Snapshots(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private static final String HTTP_1XX_TAG_VAL = "1xx";
    private static final String HTTP_2XX_TAG_VAL = "2xx";
    private static final String HTTP_3XX_TAG_VAL = "3xx";
    private static final String HTTP_4XX_TAG_VAL = "4xx";
    private static final String HTTP_5XX_TAG_VAL = "5xx";
    private static final String[] HTTP_STATUSES_TAG_VAL_ARRAY = new String[]{"1xx", "2xx", "3xx", "4xx", "5xx"};
    private static final MeterManager instance = new MeterManager();

    private MeterManager() {
        this.initHeartbeatRegistry();
        Metrics.addRegistry((MeterRegistry)this.heartbeatRegistry);
        this.initMeters();
        this.takeSnapshots();
        this.heartbeatRegistry.start(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("Metrics Publisher");
            return thread;
        });
    }

    public static MeterManager getInstance() {
        return instance;
    }

    private void initHeartbeatRegistry() {
        this.heartbeatRegistry = new StepMeterRegistry(new HeartbeatConfig(), Clock.SYSTEM){

            protected TimeUnit getBaseTimeUnit() {
                return TimeUnit.MILLISECONDS;
            }

            protected void publish() {
                MeterManager.this.takeSnapshots();
            }
        };
        this.heartbeatRegistry.config().meterFilter((MeterFilter)new HeartbeatMeterFilter());
    }

    private void initMeters() {
        if (ModeSupport.isConsole()) {
            this.initAllNodeTypesMeters(NodeContext.ADMIN);
        }
        if (ModeSupport.isEngine()) {
            this.initAllNodeTypesMeters(NodeContext.ENGINE);
            this.getTransactionCounter();
            this.getTransactionErrorsCounter();
        }
    }

    private void initAllNodeTypesMeters(NodeContext nodeContext) {
        this.getHttpResponseTimer(nodeContext);
        for (String httpStatusVal : HTTP_STATUSES_TAG_VAL_ARRAY) {
            this.getHttpResponseCodeCounter(nodeContext, httpStatusVal);
        }
        this.getConcurrentRequestSummary(nodeContext);
    }

    public Timer getTimer(String id, String ... tags) {
        return Timer.builder((String)id).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public TimerScope getTimerScope(String id, String ... tags) {
        return new TimerScope(this.getTimer(id, tags));
    }

    public Counter getCounter(String id, String ... tags) {
        return Counter.builder((String)id).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public DistributionSummary getDistributionSummary(String id, String ... tags) {
        return DistributionSummary.builder((String)id).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public Timer getHttpResponseTimer(NodeContext nodeContext) {
        return this.getTimer("response.time", "node.type", nodeContext.getTag());
    }

    public void recordResponseCode(NodeContext statsContext, HttpServletResponse response) {
        String statusCodeTagVal;
        int statusCode = response.getStatus();
        switch (String.valueOf(statusCode).charAt(0)) {
            case '1': {
                statusCodeTagVal = HTTP_1XX_TAG_VAL;
                break;
            }
            case '2': {
                statusCodeTagVal = HTTP_2XX_TAG_VAL;
                break;
            }
            case '3': {
                statusCodeTagVal = HTTP_3XX_TAG_VAL;
                break;
            }
            case '4': {
                statusCodeTagVal = HTTP_4XX_TAG_VAL;
                break;
            }
            case '5': {
                statusCodeTagVal = HTTP_5XX_TAG_VAL;
                break;
            }
            default: {
                statusCodeTagVal = String.valueOf(statusCode);
            }
        }
        this.getHttpResponseCodeCounter(statsContext, statusCodeTagVal).increment();
    }

    public DistributionSummary getConcurrentRequestSummary(NodeContext nodeContext) {
        return this.getDistributionSummary("concurrent.request", "node.type", nodeContext.getTag());
    }

    public Counter getTransactionCounter() {
        return this.getCounter("transaction.count", new String[0]);
    }

    public Counter getTransactionErrorsCounter() {
        return this.getCounter("transaction.errors", new String[0]);
    }

    public Timer getDataStoreResponseTimeTimer(String dataSourceType, String dataSourceName) {
        return this.getTimer("data.store.response.time", "ds.type", dataSourceType, "ds.name", dataSourceName);
    }

    public Counter getDataStoreErrorsCounter(String dataSourceType, String dataSourceName) {
        return this.getCounter("data.store.errors", "ds.type", dataSourceType, "ds.name", dataSourceName);
    }

    public Map<String, Object> getStats(String meterId) {
        return this.getStats(new MeterMapper(meterId));
    }

    public Map<String, Object> getStats(MeterMapper mapper) {
        return this.getStats(Collections.singleton(mapper));
    }

    public Map<String, Object> getStats(Collection<MeterMapper> mappers) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Snapshots snapshots = this.prevSnapshots;
        for (MeterMapper mapper : mappers) {
            Search search = this.heartbeatRegistry.find(mapper.getMeterId());
            for (Timer timer : search.timers()) {
                HistogramSnapshot histogramSnapshot = snapshots.getHistogramSnapshot(timer.getId());
                if (histogramSnapshot == null) continue;
                result.put(mapper.getCountName(timer.getId()), histogramSnapshot.count());
                this.addTimerStatsToMap(result, mapper.getName(timer.getId()), timer.getId(), snapshots);
            }
            for (Counter counter : search.counters()) {
                this.addCounterToMap(result, mapper.getName(counter.getId()), counter.getId(), snapshots);
            }
            for (DistributionSummary summary : search.summaries()) {
                this.addDistributionSummaryStatsToMap(result, mapper.getName(summary.getId()), summary.getId(), snapshots);
            }
            for (Gauge gauge : search.gauges()) {
                this.addGaugeToMap(result, mapper.getName(gauge.getId()), gauge.getId(), snapshots);
            }
        }
        return result;
    }

    public Map<String, Object> getHttpRequestStats(NodeContext statsContext) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        Snapshots snapshots = this.prevSnapshots;
        Timer httpResponseTimer = this.getHttpResponseTimer(statsContext);
        this.addTimerStatsToMap(results, "response.time.statistics", httpResponseTimer.getId(), snapshots);
        DistributionSummary concurrentRequestSummary = this.getConcurrentRequestSummary(statsContext);
        this.addDistributionSummaryStatsToMap(results, "response.concurrency.statistics", concurrentRequestSummary.getId(), snapshots);
        for (String httpStatus : HTTP_STATUSES_TAG_VAL_ARRAY) {
            Counter counter = this.getHttpResponseCodeCounter(statsContext, httpStatus);
            this.addCounterToMap(results, "response.http.status." + httpStatus, counter.getId(), snapshots);
        }
        HistogramSnapshot responseTimerSnapshot = snapshots.getHistogramSnapshot(httpResponseTimer.getId());
        if (responseTimerSnapshot != null) {
            results.put("response.statistics.count", responseTimerSnapshot.count());
        }
        results.put("response.statistics.window.seconds", this.monitoringService.getStatisticsWindowSecs());
        return results;
    }

    public Map<String, Object> getDataSourceResponseTimeStats() {
        MeterMapper responseTimeMapper = new MeterMapper("data.store.response.time", id -> String.format("ds.%s.%s.response.time", id.getTag("ds.type"), id.getTag("ds.name")), id -> String.format("ds.%s.%s.request.count", id.getTag("ds.type"), id.getTag("ds.name")));
        MeterMapper errorsMapper = new MeterMapper("data.store.errors", id -> String.format("ds.%s.%s.errors", id.getTag("ds.type"), id.getTag("ds.name")));
        return this.getStats(Arrays.asList(responseTimeMapper, errorsMapper));
    }

    public Map<String, Object> getTransactionCounterStats() {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        Snapshots snapshots = this.prevSnapshots;
        this.addCounterToMap(results, "transaction.count", this.getTransactionCounter().getId(), snapshots);
        this.addCounterToMap(results, "transaction.errors", this.getTransactionErrorsCounter().getId(), snapshots);
        return results;
    }

    private Counter getHttpResponseCodeCounter(NodeContext nodeContext, String statusCodeTagVal) {
        return Counter.builder((String)"response.code").tags(new String[]{"node.type", nodeContext.getTag(), "code", statusCodeTagVal}).register((MeterRegistry)Metrics.globalRegistry);
    }

    private void takeSnapshots() {
        HashMap<Meter.Id, Double> counterSnapshots = new HashMap<Meter.Id, Double>();
        HashMap<Meter.Id, HistogramSnapshot> histogramSnapshots = new HashMap<Meter.Id, HistogramSnapshot>();
        HashMap<Meter.Id, Double> gaugeSnapshots = new HashMap<Meter.Id, Double>();
        for (Meter meter : this.heartbeatRegistry.getMeters()) {
            if (meter instanceof HistogramSupport) {
                histogramSnapshots.put(meter.getId(), ((HistogramSupport)meter).takeSnapshot());
                continue;
            }
            if (meter instanceof Counter) {
                counterSnapshots.put(meter.getId(), ((Counter)meter).count());
                continue;
            }
            if (!(meter instanceof Gauge)) continue;
            gaugeSnapshots.put(meter.getId(), ((Gauge)meter).value());
        }
        this.prevSnapshots = new Snapshots(histogramSnapshots, counterSnapshots, gaugeSnapshots);
    }

    private void addTimerStatsToMap(Map<String, Object> map, String statsPrefix, Meter.Id timerId, Snapshots snapshots) {
        this.addHistogramStatsToMap(map, statsPrefix, timerId, snapshots, TimeUnit.MILLISECONDS);
    }

    private void addDistributionSummaryStatsToMap(Map<String, Object> map, String statsPrefix, Meter.Id summaryId, Snapshots snapshots) {
        this.addHistogramStatsToMap(map, statsPrefix, summaryId, snapshots, null);
    }

    private void addCounterToMap(Map<String, Object> map, String key, Meter.Id counterId, Snapshots snapshots) {
        Double value = snapshots.getCounterSnapshot(counterId);
        if (value != null) {
            map.put(key, value.longValue());
        }
    }

    private void addGaugeToMap(Map<String, Object> map, String key, Meter.Id gaugeId, Snapshots snapshots) {
        Double value = snapshots.getGaugeSnapshot(gaugeId);
        if (value != null) {
            map.put(key, value.longValue());
        }
    }

    private void addHistogramStatsToMap(Map<String, Object> map, String statsPrefix, Meter.Id meterId, Snapshots snapshots, TimeUnit timeUnit) {
        HistogramSnapshot snapshot = snapshots.getHistogramSnapshot(meterId);
        if (snapshot == null) {
            return;
        }
        ValueAtPercentile[] timerPercentileValues = snapshot.percentileValues();
        this.setPercentileValues(map, statsPrefix + ".%s.percentile", timerPercentileValues, timeUnit);
        map.put(statsPrefix + ".mean", this.getMean(snapshot, timeUnit));
        if (timerPercentileValues.length > 0) {
            map.put(statsPrefix + ".min", this.getPercentileValue(timerPercentileValues[0], timeUnit));
        }
        map.put(statsPrefix + ".max", this.getMax(snapshot, timeUnit));
    }

    private void setPercentileValues(Map<String, Object> results, String resultsKey, ValueAtPercentile[] percentileValues, TimeUnit timeUnit) {
        if (percentileValues.length > 0) {
            percentileValues = Arrays.asList(percentileValues).subList(1, percentileValues.length).toArray(new ValueAtPercentile[0]);
        }
        for (ValueAtPercentile percentile : percentileValues) {
            results.put(String.format(resultsKey, this.toPercentileString(percentile)), this.getPercentileValue(percentile, timeUnit));
        }
    }

    private double getMean(HistogramSnapshot snapshot, TimeUnit timeUnit) {
        if (timeUnit == null) {
            return snapshot.mean();
        }
        return snapshot.mean(timeUnit);
    }

    private double getMax(HistogramSnapshot snapshot, TimeUnit timeUnit) {
        if (timeUnit == null) {
            return snapshot.max();
        }
        return snapshot.max(timeUnit);
    }

    private double getPercentileValue(ValueAtPercentile valueAtPercentile, TimeUnit timeUnit) {
        if (timeUnit == null) {
            return valueAtPercentile.value();
        }
        return valueAtPercentile.value(timeUnit);
    }

    String toPercentileString(ValueAtPercentile percentile) {
        double wholeNumberPercentile = percentile.percentile() * 100.0;
        return wholeNumberPercentile % 1.0 == 0.0 ? Integer.toString((int)wholeNumberPercentile) : Double.toString(wholeNumberPercentile);
    }

    private static class Snapshots {
        private final Map<Meter.Id, HistogramSnapshot> histogramSnapshots;
        private final Map<Meter.Id, Double> counterSnapshots;
        private final Map<Meter.Id, Double> gaugeSnapshots;

        public Snapshots(Map<Meter.Id, HistogramSnapshot> histogramSnapshots, Map<Meter.Id, Double> counterSnapshots, Map<Meter.Id, Double> gaugeSnapshots) {
            this.histogramSnapshots = Collections.unmodifiableMap(histogramSnapshots);
            this.counterSnapshots = Collections.unmodifiableMap(counterSnapshots);
            this.gaugeSnapshots = Collections.unmodifiableMap(gaugeSnapshots);
        }

        public HistogramSnapshot getHistogramSnapshot(Meter.Id id) {
            return this.histogramSnapshots.get(id);
        }

        public Double getCounterSnapshot(Meter.Id id) {
            return this.counterSnapshots.get(id);
        }

        public Double getGaugeSnapshot(Meter.Id id) {
            return this.gaugeSnapshots.get(id);
        }
    }

    public static enum NodeContext {
        ENGINE("engine"),
        ADMIN("admin");

        private final String tag;

        private NodeContext(String tag) {
            this.tag = tag;
        }

        public boolean nameMatches(String compareTo) {
            if (compareTo == null) {
                return false;
            }
            return compareTo.equalsIgnoreCase(this.toString());
        }

        public String getTag() {
            return this.tag;
        }
    }
}

