/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.metrics;

import com.pingidentity.common.util.resiliency.ResiliencyManager;
import com.pingidentity.common.util.resiliency.ResiliencyManagerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class TimerScope
implements AutoCloseable {
    private final ResiliencyManagerFactory resiliencyManagerFactory = MgmtFactory.getResiliencyManagerFactory();
    private ResiliencyManager resiliencyManager;
    private final Timer timer;
    private final long start = System.currentTimeMillis();

    public TimerScope(Timer timer) {
        if (timer != null) {
            this.resiliencyManager = this.resiliencyManagerFactory.getResiliencyManager(timer.getId().getName());
            this.resiliencyManager.initializeServiceInstance(TimerScope.getBulkheadId(timer));
        }
        this.timer = timer;
    }

    public static TimerScope getTimerScopeForService(String serviceName, String ... tags) {
        Timer timer = Timer.builder((String)serviceName).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        return new TimerScope(timer);
    }

    public static TimerScope empty() {
        return new TimerScope(null);
    }

    @Override
    public void close() {
        if (this.timer != null) {
            this.timer.record(System.currentTimeMillis() - this.start, TimeUnit.MILLISECONDS);
            if (this.resiliencyManager != null) {
                this.resiliencyManager.cleanUpServiceInstance(TimerScope.getBulkheadId(this.timer));
            }
        }
    }

    private static String getBulkheadId(Timer timer) {
        StringBuilder bulkheadId = new StringBuilder(timer.getId().getName());
        timer.getId().getTags().forEach(tag -> bulkheadId.append(".").append(tag.getKey()).append(".").append(tag.getValue()));
        return bulkheadId.toString();
    }
}

