/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingonev2;

import com.pingidentity.pingcommons.http.uri.HttpUri;
import com.pingidentity.pingcommons.http.uri.HttpUriFactory;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import java.util.Arrays;
import java.util.List;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public final class PingOneDomainValidator {
    private static final String CONFIG_STORE_NAME = "com.pingidentity.pingonev2.PingOneDomainValidator";
    private final ConfigStore CONFIG_STORE;
    private static final String CONFIG_STORE_PING_ONE_DOMAINS = "pingone-domains";
    private static final List<String> CONFIG_STORE_PING_ONE_DOMAINS_DEFAULTS = Arrays.asList(".pingone.com", ".pingone.ca", ".pingone.eu", ".pingone.asia", ".pingone.com.au", ".pingone.sg");
    private final HttpUriFactory REDIRECT_URL;
    private final String url;

    public PingOneDomainValidator(String url) {
        this.url = url;
        this.CONFIG_STORE = ConfigStoreFarm.getConfig(CONFIG_STORE_NAME);
        this.REDIRECT_URL = HttpUriFactory.createRedirectUriFactory((HttpUriFactory.Params)HttpUriFactory.DEFUALT_PARAMS);
    }

    PingOneDomainValidator(String url, ConfigStore configStore, HttpUriFactory httpUriFactory) {
        this.url = url;
        this.CONFIG_STORE = configStore;
        this.REDIRECT_URL = httpUriFactory;
    }

    public boolean isValid() {
        List<String> pingOneDomains = this.CONFIG_STORE.getListValue(CONFIG_STORE_PING_ONE_DOMAINS, CONFIG_STORE_PING_ONE_DOMAINS_DEFAULTS);
        try {
            HttpUri httpUri = this.REDIRECT_URL.create(this.url);
            if (!"https".equals(httpUri.getScheme())) {
                return false;
            }
            if (httpUri.getPort() != 443) {
                return false;
            }
            return pingOneDomains.stream().anyMatch(s -> httpUri.getHost().endsWith((String)s));
        }
        catch (InvalidHttpUriException e) {
            return false;
        }
    }
}

