/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingonev2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingidentity.pingonev2.PingOneGatewayInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class PingOneGateway
implements Serializable {
    private String id;
    private String name;
    private String type;
    private String vendor;
    private String connectionSecurity;
    private Kerberos kerberos;
    private List<Alert> currentAlerts = new ArrayList<Alert>();
    private boolean enabled;
    @JsonProperty(value="_embedded")
    private Embedded embedded;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVendor() {
        if ("Microsoft Active Directory".equals(this.vendor)) {
            return "Active Directory";
        }
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getConnectionSecurity() {
        return this.connectionSecurity;
    }

    public void setConnectionSecurity(String connectionSecurity) {
        this.connectionSecurity = connectionSecurity;
    }

    public List<Alert> getCurrentAlerts() {
        if (this.getEmbedded() != null && CollectionUtils.isNotEmpty(this.getEmbedded().getInstances())) {
            for (PingOneGatewayInstance gatewayInstance : this.getEmbedded().getInstances()) {
                if (!CollectionUtils.isNotEmpty(gatewayInstance.getCurrentAlerts())) continue;
                for (Alert alert : gatewayInstance.getCurrentAlerts()) {
                    if (!this.currentAlerts.stream().noneMatch(o -> o.getCategory().equals(alert.getCategory()))) continue;
                    this.currentAlerts.add(alert);
                }
            }
        }
        this.currentAlerts.sort(Comparator.comparing(Alert::getSeverityInt));
        return this.currentAlerts;
    }

    public void setCurrentAlerts(List<Alert> currentAlerts) {
        this.currentAlerts = currentAlerts != null ? currentAlerts : new ArrayList();
    }

    public boolean isKerberosAuthenticationEnabled() {
        return this.kerberos != null;
    }

    public void setKerberos(Kerberos kerberos) {
        this.kerberos = kerberos;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLDAPGateway() {
        return "LDAP".equals(this.type);
    }

    public Embedded getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(Embedded _embedded) {
        this.embedded = _embedded;
    }

    public static class Kerberos
    implements Serializable {
        private String serviceAccountUserPrincipalName;
        private Integer minutesToRetainPreviousCredentials;

        public String getServiceAccountUserPrincipalName() {
            return this.serviceAccountUserPrincipalName;
        }

        public void setServiceAccountUserPrincipalName(String serviceAccountUserPrincipalName) {
            this.serviceAccountUserPrincipalName = serviceAccountUserPrincipalName;
        }

        public Integer getMinutesToRetainPreviousCredentials() {
            return this.minutesToRetainPreviousCredentials;
        }

        public void setMinutesToRetainPreviousCredentials(Integer minutesToRetainPreviousCredentials) {
            this.minutesToRetainPreviousCredentials = minutesToRetainPreviousCredentials;
        }
    }

    public static class Embedded
    implements Serializable {
        private List<PingOneGatewayInstance> instances;

        public List<PingOneGatewayInstance> getInstances() {
            return this.instances;
        }

        public void setInstances(List<PingOneGatewayInstance> instances) {
            this.instances = instances;
        }
    }

    public static class Alert
    implements Serializable {
        public static final int ERROR_SEVERITY_INT = 0;
        private String category;
        private String detail;
        private String severity;

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        public int getSeverityInt() {
            switch (this.severity) {
                case "ERROR": {
                    return 0;
                }
                case "WARNING": {
                    return 1;
                }
            }
            return 3;
        }
    }
}

