/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingonev2;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.pingidentity.common.security.KerberosException;
import com.pingidentity.pingonev2.AccessTokenResponse;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneDomainValidator;
import com.pingidentity.pingonev2.PingOneEnvironment;
import com.pingidentity.pingonev2.PingOneGateway;
import com.pingidentity.pingonev2.ValidateKerberosTicketRequest;
import com.pingidentity.pingonev2.ValidateKerberosTicketResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class PingOneV2APIClient {
    public static final String PARAM_NAME_GRANT_TYPE = "grant_type";
    public static final String PARAM_NAME_SUBJECT_TOKEN_TYPE = "subject_token_type";
    public static final String PARAM_NAME_SUBJECT_TOKEN = "subject_token";
    public static final String CRED_EXCHANGE_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    public static final String CRED_EXCHANGE_TOKEN_TYPE = "pingone_gateway_credential";
    public static final String CRED_EXCHANGE_PATH = "/as/token";
    public static final String ENVIRONMENTS_PATH = "/v1/environments";
    public static final String GATEWAYS_PATH = "/v1/environments/%s/gateways?expand=instances";
    public static final String VALIDATE_KERBEROS_TOKEN_PATH = "/v1/environments/%s/gateways/%s/kerberosToken";
    private final HttpClient httpClient;
    private final String credential;
    private final CredentialReader credentialReader;
    private volatile String cachedAccessToken = null;
    private final ObjectMapper credentialMapper = this.getCredentialExchangeMapper();
    private final ObjectMapper mapper = this.getEnvironmentsCallMapper();
    private static final Log log = LogFactory.getLog(PingOneV2APIClient.class);

    public PingOneV2APIClient(HttpClient httpClient, String credential) throws InvalidGatewayCredentialException {
        this.httpClient = httpClient;
        this.credential = credential;
        this.credentialReader = new CredentialReader(credential);
    }

    public String exchangeGatewayCredential() throws InvalidGatewayCredentialException, IOException {
        String accessToken;
        HttpPost httpPost = new HttpPost(this.makeCredentialExchangeUrl(this.credentialReader.getOauthBaseUrl(), this.credentialReader.getEnvId()));
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(PARAM_NAME_GRANT_TYPE, CRED_EXCHANGE_GRANT_TYPE));
        params.add(new BasicNameValuePair(PARAM_NAME_SUBJECT_TOKEN_TYPE, CRED_EXCHANGE_TOKEN_TYPE));
        params.add(new BasicNameValuePair(PARAM_NAME_SUBJECT_TOKEN, this.credential));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = this.doRequest((HttpRequestBase)httpPost);
        HttpEntity respEntity = response.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)respEntity, (Charset)Consts.UTF_8);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String message = "Error exchanging gateway credential. Request to " + httpPost.getURI() + " returned " + statusCode + ": " + responseString;
            log.debug((Object)message);
            throw new InvalidGatewayCredentialException(responseString);
        }
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)this.credentialMapper.readValue(responseString, AccessTokenResponse.class);
        this.cachedAccessToken = accessToken = accessTokenResponse.getAccessToken();
        return accessToken;
    }

    public List<PingOneEnvironment> getEnvironments() throws InvalidGatewayCredentialException, IOException {
        HttpGet httpGet = new HttpGet(this.makeEnvironmentsUrl(this.credentialReader.getApiBaseUrl()));
        HttpResponse response = this.doRequestWithAccessToken((HttpRequestBase)httpGet);
        HttpEntity respEntity = response.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)respEntity, (Charset)Consts.UTF_8);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String message = "Error fetching environments list. Request to " + httpGet.getURI() + " returned " + statusCode + ": " + responseString;
            log.debug((Object)message);
            throw new InvalidGatewayCredentialException(responseString);
        }
        JsonNode jsonNode = this.mapper.readTree(responseString);
        JsonNode environments = jsonNode.get("_embedded").get("environments");
        CollectionType typeReference = TypeFactory.defaultInstance().constructCollectionType(List.class, PingOneEnvironment.class);
        List environmentList = (List)this.mapper.readValue(environments.toString(), (JavaType)typeReference);
        return environmentList;
    }

    public List<PingOneGateway> getGateways(String envId) throws InvalidGatewayCredentialException, IOException {
        HttpGet httpGet = new HttpGet(this.makeGatewaysUrl(this.credentialReader.getApiBaseUrl(), envId));
        HttpResponse response = this.doRequestWithAccessToken((HttpRequestBase)httpGet);
        HttpEntity respEntity = response.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)respEntity, (Charset)Consts.UTF_8);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String message = "Error fetching environments list. Request to " + httpGet.getURI() + " returned " + statusCode + ": " + responseString;
            log.debug((Object)message);
            throw new InvalidGatewayCredentialException(responseString);
        }
        JsonNode jsonNode = this.mapper.readTree(responseString);
        JsonNode gateways = jsonNode.get("_embedded").get("gateways");
        CollectionType typeReference = TypeFactory.defaultInstance().constructCollectionType(List.class, PingOneGateway.class);
        List gatewayList = (List)this.mapper.readValue(gateways.toString(), (JavaType)typeReference);
        return gatewayList;
    }

    public ValidateKerberosTicketResponse validateKerberosTicket(byte[] kerberosToken, String envId, String gatewayId) throws InvalidGatewayCredentialException, IOException, KerberosException {
        HttpPost httpPost = new HttpPost(this.makeValidateKerberosTicketUrl(this.credentialReader.getApiBaseUrl(), envId, gatewayId));
        String kerberosTokenString = new String(Base64.encodeBase64((byte[])kerberosToken), Consts.UTF_8);
        ValidateKerberosTicketRequest validateKerberosTicketRequest = new ValidateKerberosTicketRequest(kerberosTokenString);
        StringEntity entity = new StringEntity(this.mapper.writeValueAsString((Object)validateKerberosTicketRequest), Consts.UTF_8);
        httpPost.setHeader("Content-Type", "application/vnd.pingidentity.kerberos.check+json");
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = this.doRequestWithAccessToken((HttpRequestBase)httpPost);
        HttpEntity respEntity = response.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)respEntity, (Charset)Consts.UTF_8);
        int statusCode = response.getStatusLine().getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request to " + httpPost.getURI() + " returned " + statusCode + ": " + responseString));
        }
        if (statusCode == 400) {
            throw new KerberosException("Invalid kerberos service ticket.");
        }
        if (statusCode != 200) {
            throw new InvalidGatewayCredentialException("Error validating Kerberos ticket.");
        }
        return (ValidateKerberosTicketResponse)this.mapper.readValue(responseString, ValidateKerberosTicketResponse.class);
    }

    private HttpResponse doRequestWithAccessToken(HttpRequestBase httpRequest) throws IOException, InvalidGatewayCredentialException {
        HttpResponse response = null;
        int remainingTries = 2;
        while (remainingTries > 0) {
            String accessToken = this.cachedAccessToken;
            if (accessToken == null) {
                accessToken = this.exchangeGatewayCredential();
                remainingTries = 1;
            }
            httpRequest.setHeader("Authorization", "Bearer " + accessToken);
            response = this.doRequest(httpRequest);
            --remainingTries;
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401 || statusCode == 403) {
                if (remainingTries > 0) {
                    log.debug((Object)("Request to " + httpRequest.getURI() + " returned " + statusCode + ", refreshing access token"));
                }
                this.cachedAccessToken = null;
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                continue;
            }
            remainingTries = 0;
        }
        return response;
    }

    private HttpResponse doRequest(HttpRequestBase request) throws IOException {
        HttpResponse response;
        log.debug((Object)("Sending " + request.getMethod() + " request to " + request.getURI()));
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            log.debug((Object)("Error sending " + request.getMethod() + " request to " + request.getURI() + ": " + e.getMessage()));
            throw e;
        }
        return response;
    }

    private String makeCredentialExchangeUrl(String oauthBaseUrl, String envId) {
        return oauthBaseUrl + "/" + envId + CRED_EXCHANGE_PATH;
    }

    private String makeEnvironmentsUrl(String apiBaseUrl) {
        return apiBaseUrl + ENVIRONMENTS_PATH;
    }

    private String makeGatewaysUrl(String apiBaseUrl, String envId) {
        return String.format(apiBaseUrl + GATEWAYS_PATH, envId);
    }

    private String makeValidateKerberosTicketUrl(String apiBaseUrl, String envId, String gatewayId) {
        return String.format(apiBaseUrl + VALIDATE_KERBEROS_TOKEN_PATH, envId, gatewayId);
    }

    private ObjectMapper getCredentialExchangeMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return objectMapper;
    }

    private ObjectMapper getEnvironmentsCallMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        return objectMapper;
    }

    public static class CredentialReader {
        private String envId;
        private String gatewayId;
        private String oauthBaseUrl;
        private String apiBaseUrl;

        public CredentialReader(String credential) throws InvalidGatewayCredentialException {
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
            try {
                JwtClaims claims = jwtConsumer.processToClaims(credential);
                this.envId = claims.getStringClaimValue("environmentId");
                this.gatewayId = claims.getStringClaimValue("gatewayId");
                this.apiBaseUrl = claims.getStringClaimValue("aud");
                this.oauthBaseUrl = claims.getClaimValueAsString("authUrl");
                if (StringUtils.isBlank((CharSequence)this.envId) || StringUtils.isBlank((CharSequence)this.gatewayId) || StringUtils.isBlank((CharSequence)this.apiBaseUrl) || StringUtils.isBlank((CharSequence)this.oauthBaseUrl)) {
                    String errorMessage = "Gateway credential does not contain all required claims.";
                    log.debug((Object)("Error processing gateway credential: " + errorMessage));
                    throw new InvalidGatewayCredentialException(errorMessage);
                }
                PingOneDomainValidator oauthBaseUrlValidator = new PingOneDomainValidator(this.oauthBaseUrl);
                if (!oauthBaseUrlValidator.isValid()) {
                    String errorMessage = "'authUrl' claim is invalid";
                    log.debug((Object)("Error processing gateway credential: " + errorMessage));
                    throw new InvalidGatewayCredentialException(errorMessage);
                }
                PingOneDomainValidator apiBaseUrlValidator = new PingOneDomainValidator(this.apiBaseUrl);
                if (!apiBaseUrlValidator.isValid()) {
                    String errorMessage = "'aud' claim is invalid";
                    log.debug((Object)("Error processing gateway credential: " + errorMessage));
                    throw new InvalidGatewayCredentialException(errorMessage);
                }
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                log.debug((Object)("Error processing gateway credential: " + e.getMessage()));
                throw new InvalidGatewayCredentialException(e.getMessage());
            }
        }

        public String getEnvId() {
            return this.envId;
        }

        public String getGatewayId() {
            return this.gatewayId;
        }

        public String getOauthBaseUrl() {
            return this.oauthBaseUrl;
        }

        public String getApiBaseUrl() {
            return this.apiBaseUrl;
        }
    }
}

