/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.rbac.impl;

import com.pingidentity.pingcommons.rbac.Permission;
import com.pingidentity.pingcommons.rbac.PermissionSet;
import com.pingidentity.pingcommons.rbac.RbacAuthorizationException;
import com.pingidentity.rbac.CertificateMgmtPermissions;
import com.pingidentity.rbac.Permissions;
import com.pingidentity.rbac.RbacManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.mgmt.AdminAPIAuthManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class RbacManagerImpl
implements RbacManager {
    private Map<String, Set<Permission>> rolesToPermissions = new HashMap<String, Set<Permission>>();
    private final AdminAPIAuthManager adminAPIAuthManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbacManagerImpl() {
        RbacManagerImpl rbacManagerImpl = this;
        synchronized (rbacManagerImpl) {
            this.adminAPIAuthManager = AdminAPIAuthManager.getInstance();
            this.initializeAdminPermissions();
            this.initializeAuditorPermissions();
            this.initializeCryptoAdminPermissions();
            this.initializeConfigArchivePermissions();
            this.initializeUserAdminPermissions();
            this.initializeDataCollectionAdminPermissions();
        }
    }

    @Override
    public synchronized void checkAccess(AdministrativeUser user, Permission permission) throws RbacAuthorizationException {
        if (user == null) {
            throw new RbacAuthorizationException("There is no user associate with this session.");
        }
        if (!user.isActive()) {
            throw new RbacAuthorizationException("The user '" + user.getUserName() + "' is not active and is not authorized to perform this action.");
        }
        if (user.getChangeRequired()) {
            throw new RbacAuthorizationException("This user '" + user.getUserName() + "' needs to change their password. Operations for this user are not allowed until a new password has been set.");
        }
        List<String> roles = this.getUserRoles(user);
        for (String role : roles) {
            Set<Permission> rolePermissions = this.rolesToPermissions.get(role);
            if (rolePermissions == null || !rolePermissions.contains(permission)) continue;
            return;
        }
        String message = "User '" + user.getUserName() + "' does not have permission to perform the " + permission.getAction() + " action on resource " + permission.getResourcePath();
        throw new RbacAuthorizationException(message);
    }

    @Override
    public synchronized boolean tryCheckAccess(AdministrativeUser user, Permission permission) {
        try {
            this.checkAccess(user, permission);
            return true;
        }
        catch (RbacAuthorizationException e) {
            return false;
        }
    }

    private synchronized void initializeAdminPermissions() {
        HashSet<Permission> adminPermissions = new HashSet<Permission>();
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.IDP_CONNECTIONS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SP_CONNECTIONS);
        this.addPermissions(adminPermissions, Permissions.CLUSTER);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.CLUSTER_STATUS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_AUTH_SERVER_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OPENID_CONNECT);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_CLIENT);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_RO_CREDENTIALS_MAPPINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_IDP_ADAPTER_MAPPING);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_APC_MAPPING);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_TEPP_MAPPING);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_ACCESS_TOKEN_MAPPINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_CLIENT_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_ISSUERS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_DYNAMIC_CLIENT_REGISTRATION_POLICIES_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SERVER_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.VERSION);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_ACCESS_TOKEN_MANAGERS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.IDP_ADAPTERS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.TOKEN_PROCESSORS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.TOKEN_GENERATORS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.TOKEN_TO_TOKEN_MAPPING);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SP_ADAPTERS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SP_TARGET_URL_MAPPINGS);
        this.addPermissions(adminPermissions, Permissions.PLUGIN_ACTION);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.PASSWORD_CREDENTIAL_VALIDATORS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.DATA_STORES);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.IDP_TO_SP_ADAPTER_MAPPINGS);
        this.addPermissions(adminPermissions, Permissions.CONN_METADATA);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.KERBEROS_REALMS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.IDP_DEFAULT_URL);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SP_DEFAULT_URLS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.AUTHENTICATION_POLICY_CONTRACTS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.AUTHENTICATION_API);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.AUTHENTICATION_SELECTORS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.AUTHENTICATION_POLICIES);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SESSION_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.LOCAL_IDENTITY_PROFILES);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.REDIRECT_VALIDATION);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.APC_TO_SP_ADAPTER_MAPPING);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.IDP_STS_REQUEST_PARAM_CONTRACT);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.LICENSE);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.VIRTUAL_HOST_NAMES_VALIDATION);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.ADMINISTRATIVE_ACCOUNTS_CHANGE_PASSWORD);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.EXTENDED_PROPERTIES);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.NOTIFICATION_PUBLISHERS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OOB_AUTH_PLUGINS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.CIBA_SERVER_POLICY);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.TOKEN_EXCHANGE_PROCESSORS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.TOKEN_EXCHANGE_GENERATORS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.TOKEN_EXCHANGE_PROCESSOR_TO_TOKEN_GENERATOR);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.INCOMING_PROXY_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.PROTOCOL_METADATA);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SERVICE_AUTHENTICATION);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.PINGONEFORENTERPRISE_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.PINGONE_CONNECTIONS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.SECRET_MANAGERS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.CONFIGURATION_ENCRYPTION_KEYS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.WS_TRUST_STS_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.GENERAL_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.FEDERATION_INFO_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.LOG_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.IDENTITY_STORE_PROVISIONER_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_AUTHORIZATION_DETAIL_PROCESSOR);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.OAUTH_AUTHORIZATION_DETAIL_TYPES);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.CAPTCHA_PROVIDERS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.ADMIN_API_CORS_SETTINGS);
        this.addPermissions(adminPermissions, (PermissionSet)Permissions.AUDIT_LOG_SETTINGS);
        this.addInternalPermissions(adminPermissions);
        this.rolesToPermissions.put("Admin", adminPermissions);
    }

    private synchronized void initializeAuditorPermissions() {
        HashSet<Permission> auditorPermissions = new HashSet<Permission>();
        auditorPermissions.add(Permissions.IDP_CONNECTIONS.READ);
        auditorPermissions.add(Permissions.SP_CONNECTIONS.READ);
        auditorPermissions.add(Permissions.CLUSTER_STATUS.READ);
        auditorPermissions.add(CertificateMgmtPermissions.KEY_ALGORITHMS.READ);
        auditorPermissions.add(CertificateMgmtPermissions.SIGNING_KEY_PAIRS.READ);
        auditorPermissions.add(Permissions.OAUTH_AUTH_SERVER_SETTINGS.READ);
        auditorPermissions.add(Permissions.OPENID_CONNECT.READ);
        auditorPermissions.add(Permissions.OAUTH_CLIENT.READ);
        auditorPermissions.add(Permissions.OAUTH_RO_CREDENTIALS_MAPPINGS.READ);
        auditorPermissions.add(Permissions.OAUTH_IDP_ADAPTER_MAPPING.READ);
        auditorPermissions.add(Permissions.OAUTH_APC_MAPPING.READ);
        auditorPermissions.add(Permissions.OAUTH_TEPP_MAPPING.READ);
        auditorPermissions.add(Permissions.OAUTH_ACCESS_TOKEN_MAPPINGS.READ);
        auditorPermissions.add(Permissions.OAUTH_CLIENT_SETTINGS.READ);
        auditorPermissions.add(Permissions.OAUTH_ISSUERS.READ);
        auditorPermissions.add(Permissions.OAUTH_DYNAMIC_CLIENT_REGISTRATION_POLICIES_SETTINGS.READ);
        auditorPermissions.add(Permissions.SERVER_SETTINGS.READ);
        auditorPermissions.add(Permissions.VERSION.READ);
        auditorPermissions.add(Permissions.OAUTH_ACCESS_TOKEN_MANAGERS.READ);
        auditorPermissions.add(Permissions.IDP_ADAPTERS.READ);
        auditorPermissions.add(Permissions.TOKEN_PROCESSORS.READ);
        auditorPermissions.add(Permissions.TOKEN_GENERATORS.READ);
        auditorPermissions.add(Permissions.IDP_STS_REQUEST_PARAM_CONTRACT.READ);
        auditorPermissions.add(Permissions.SP_ADAPTERS.READ);
        auditorPermissions.add(Permissions.SP_TARGET_URL_MAPPINGS.READ);
        auditorPermissions.add(Permissions.SSL_SERVER_KEY_PAIRS.READ);
        auditorPermissions.add(Permissions.PASSWORD_CREDENTIAL_VALIDATORS.READ);
        auditorPermissions.add(Permissions.DATA_STORES.READ);
        auditorPermissions.add(Permissions.REDIRECT_VALIDATION.READ);
        auditorPermissions.add(Permissions.IDP_TO_SP_ADAPTER_MAPPINGS.READ);
        auditorPermissions.add(Permissions.APC_TO_SP_ADAPTER_MAPPING.READ);
        auditorPermissions.add(Permissions.TOKEN_TO_TOKEN_MAPPING.READ);
        auditorPermissions.add(Permissions.SSL_CLIENT_KEY_PAIRS.READ);
        auditorPermissions.add(Permissions.CERTIFICATE_CA.READ);
        auditorPermissions.add(Permissions.CERTIFICATE_GROUPS.READ);
        auditorPermissions.add(Permissions.KERBEROS_REALMS.READ);
        auditorPermissions.add(Permissions.IDP_DEFAULT_URL.READ);
        auditorPermissions.add(Permissions.SP_DEFAULT_URLS.READ);
        auditorPermissions.add(Permissions.AUTHENTICATION_POLICY_CONTRACTS.READ);
        auditorPermissions.add(Permissions.AUTHENTICATION_API.READ);
        auditorPermissions.add(Permissions.AUTHENTICATION_SELECTORS.READ);
        auditorPermissions.add(Permissions.AUTHENTICATION_POLICIES.READ);
        auditorPermissions.add(Permissions.METADATA_URLS.READ);
        auditorPermissions.add(Permissions.SESSION_SETTINGS.READ);
        auditorPermissions.add(Permissions.LOCAL_IDENTITY_PROFILES.READ);
        auditorPermissions.add(Permissions.OAUTH_OIDC_KEYS.READ);
        auditorPermissions.add(Permissions.LICENSE.READ);
        auditorPermissions.add(Permissions.VIRTUAL_HOST_NAMES_VALIDATION.READ);
        auditorPermissions.add(Permissions.NOTIFICATION_PUBLISHERS.READ);
        auditorPermissions.add(Permissions.EXTENDED_PROPERTIES.READ);
        auditorPermissions.add(Permissions.NOTIFICATION_PUBLISHERS.READ);
        auditorPermissions.add(Permissions.EXTENDED_PROPERTIES.READ);
        auditorPermissions.add(Permissions.OOB_AUTH_PLUGINS.READ);
        auditorPermissions.add(Permissions.CIBA_SERVER_POLICY.READ);
        auditorPermissions.add(Permissions.TOKEN_EXCHANGE_PROCESSORS.READ);
        auditorPermissions.add(Permissions.TOKEN_EXCHANGE_GENERATORS.READ);
        auditorPermissions.add(Permissions.TOKEN_EXCHANGE_PROCESSOR_TO_TOKEN_GENERATOR.READ);
        auditorPermissions.add(Permissions.INCOMING_PROXY_SETTINGS.READ);
        auditorPermissions.add(Permissions.PROTOCOL_METADATA.READ);
        auditorPermissions.add(Permissions.SERVICE_AUTHENTICATION.READ);
        auditorPermissions.add(Permissions.PINGONEFORENTERPRISE_SETTINGS.READ);
        auditorPermissions.add(Permissions.PINGONE_CONNECTIONS.READ);
        this.addPermissions(auditorPermissions, (PermissionSet)Permissions.ADMINISTRATIVE_ACCOUNTS_CHANGE_PASSWORD);
        auditorPermissions.add(Permissions.SECRET_MANAGERS.READ);
        auditorPermissions.add(Permissions.CONFIGURATION_ENCRYPTION_KEYS.READ);
        auditorPermissions.add(Permissions.WS_TRUST_STS_SETTINGS.READ);
        auditorPermissions.add(Permissions.GENERAL_SETTINGS.READ);
        auditorPermissions.add(Permissions.FEDERATION_INFO_SETTINGS.READ);
        auditorPermissions.add(Permissions.LOG_SETTINGS.READ);
        auditorPermissions.add(Permissions.IDENTITY_STORE_PROVISIONER_SETTINGS.READ);
        auditorPermissions.add(Permissions.OAUTH_AUTHORIZATION_DETAIL_PROCESSOR.READ);
        auditorPermissions.add(Permissions.OAUTH_AUTHORIZATION_DETAIL_TYPES.READ);
        auditorPermissions.add(Permissions.CAPTCHA_PROVIDERS.READ);
        auditorPermissions.add(Permissions.ADMIN_API_CORS_SETTINGS.READ);
        auditorPermissions.add(Permissions.AUDIT_LOG_SETTINGS.READ);
        this.addInternalPermissions(auditorPermissions);
        this.rolesToPermissions.put("Auditor", auditorPermissions);
    }

    private synchronized void initializeCryptoAdminPermissions() {
        HashSet<Permission> cryptoAdminPermissions = new HashSet<Permission>();
        cryptoAdminPermissions.add(Permissions.LICENSE.READ);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)CertificateMgmtPermissions.KEY_ALGORITHMS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)CertificateMgmtPermissions.SIGNING_KEY_PAIRS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.SSL_SERVER_KEY_PAIRS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.SSL_CLIENT_KEY_PAIRS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.CERTIFICATE_CA);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.CERTIFICATE_GROUPS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.METADATA_URLS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.OAUTH_OIDC_KEYS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.ADMINISTRATIVE_ACCOUNTS_CHANGE_PASSWORD);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.CERTIFICATES_REVOCATION);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.CONFIGURATION_ENCRYPTION_KEYS);
        this.addPermissions(cryptoAdminPermissions, (PermissionSet)Permissions.PF_AIC_WS);
        this.addInternalPermissions(cryptoAdminPermissions);
        cryptoAdminPermissions.add(Permissions.OAUTH_ISSUERS.READ);
        this.rolesToPermissions.put("CryptoAdmin", cryptoAdminPermissions);
    }

    private synchronized void initializeUserAdminPermissions() {
        HashSet<Permission> userAdminPermissions = new HashSet<Permission>();
        this.addPermissions(userAdminPermissions, (PermissionSet)Permissions.LICENSE);
        this.addPermissions(userAdminPermissions, (PermissionSet)Permissions.ADMINISTRATIVE_ACCOUNTS);
        this.addPermissions(userAdminPermissions, (PermissionSet)Permissions.ADMINISTRATIVE_ACCOUNTS_CHANGE_PASSWORD);
        this.addPermissions(userAdminPermissions, (PermissionSet)Permissions.ADMINISTRATIVE_ACCOUNTS_RESET_PASSWORD);
        this.addInternalPermissions(userAdminPermissions);
        this.rolesToPermissions.put("UserAdmin", userAdminPermissions);
    }

    private synchronized void initializeDataCollectionAdminPermissions() {
        HashSet<Permission> dataCollectionAdminPermissions = new HashSet<Permission>();
        this.addPermissions(dataCollectionAdminPermissions, (PermissionSet)Permissions.COLLECT_SUPPORT_DATA);
        this.rolesToPermissions.put("DataCollectionAdmin", dataCollectionAdminPermissions);
    }

    private synchronized void initializeConfigArchivePermissions() {
        HashSet<Permission> configArchiveAdminPermissions = new HashSet<Permission>();
        this.addPermissions(configArchiveAdminPermissions, Permissions.CONFIG_ARCHIVE);
        this.addPermissions(configArchiveAdminPermissions, Permissions.BULK_OPERATIONS);
        this.addPermissions(configArchiveAdminPermissions, (PermissionSet)Permissions.ADMINISTRATIVE_ACCOUNTS_CHANGE_PASSWORD);
        this.addPermissions(configArchiveAdminPermissions, (PermissionSet)Permissions.CONFIG_STORE);
        this.rolesToPermissions.put("ConfigArchiveAdmin", configArchiveAdminPermissions);
    }

    private List<String> getUserRoles(AdministrativeUser user) {
        ArrayList<String> roles = new ArrayList<String>();
        if (user == null) {
            return roles;
        }
        boolean isAdmin = user.isAdmin();
        boolean isAuditor = user.isAuditor();
        boolean isCryptoManager = user.isCryptoManager();
        boolean isUserManager = user.isAdminManager();
        boolean isExpressionAdmin = user.isExpressionAdmin();
        boolean isDataCollectionAdmin = user.isDataCollectionAdmin();
        if (isAdmin) {
            roles.add("Admin");
        }
        if (isAuditor) {
            roles.add("Auditor");
        }
        if (isCryptoManager) {
            roles.add("CryptoAdmin");
        }
        boolean isNativeAuth = this.adminAPIAuthManager.isNative();
        if (isAdmin && isCryptoManager && isUserManager && isExpressionAdmin && (isDataCollectionAdmin || !isNativeAuth)) {
            roles.add("ConfigArchiveAdmin");
        }
        if (isUserManager) {
            roles.add("UserAdmin");
        }
        if (isExpressionAdmin) {
            roles.add("ExpressionAdmin");
        }
        if (isDataCollectionAdmin && isAdmin && isUserManager && isCryptoManager) {
            roles.add("DataCollectionAdmin");
        }
        return roles;
    }

    private void addPermissions(Set<Permission> permissions, PermissionSet permissionSet) {
        permissions.addAll(permissionSet.getPermissions());
    }

    private void addInternalPermissions(Set<Permission> permissions) {
        this.addPermissions(permissions, (PermissionSet)Permissions.INTERNAL_UI_SETTINGS);
        this.addPermissions(permissions, (PermissionSet)Permissions.INTERNAL_ACTIVE_ADMINISTRATORS);
        this.addPermissions(permissions, (PermissionSet)Permissions.INTERNAL_NODES);
        this.addPermissions(permissions, (PermissionSet)Permissions.INTERNAL_ACTIVE_PASSIVE_CONSOLE_INFO);
        this.addPermissions(permissions, (PermissionSet)Permissions.UI_USER_PREFERENCES);
        this.addPermissions(permissions, (PermissionSet)Permissions.NOTIFICATIONS);
        this.addPermissions(permissions, (PermissionSet)Permissions.INTERNAL_DB_WARNINGS);
        this.addPermissions(permissions, (PermissionSet)Permissions.LICENSE_EXPIRY_STATUS);
        this.addPermissions(permissions, (PermissionSet)Permissions.REPLICATION_INFO);
        this.addPermissions(permissions, (PermissionSet)Permissions.TEST_EXPRESSION);
        this.addPermissions(permissions, (PermissionSet)Permissions.VALIDATE_EXPRESSION);
        this.addPermissions(permissions, (PermissionSet)Permissions.EXTEND_SESSION);
        this.addPermissions(permissions, (PermissionSet)Permissions.CLIENT_STORAGE);
    }
}

