/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption;

import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.reencryption.ReencryptionTarget;
import com.pingidentity.reencryption.Replacement;
import com.pingidentity.reencryption.Updater;
import com.pingidentity.reencryption.UpdaterFactory;
import com.pingidentity.reencryption.filescanner.FileScanner;
import com.pingidentity.reencryption.filescanner.JsonFileScanner;
import com.pingidentity.reencryption.filescanner.PropertiesFileScanner;
import com.pingidentity.reencryption.filescanner.TextFileScanner;
import com.pingidentity.reencryption.filescanner.XmlFileScanner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.common.CryptoUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ReencryptUtils {
    private static final String obfJwePrefix = "OBF:JWE:";
    private static final String hsmPrefix = "HSM:";
    private static final String aesPrefix = "OBF:AES:";
    private static final Logger log = LogManager.getLogger(ReencryptUtils.class);

    /*
     * Loose catch block
     */
    public static Replacement processValue(String value, JsonWebKeySet decryptionKeySet) {
        String[] valuePrefixArray;
        block7: {
            valuePrefixArray = ReencryptUtils.handlePrefix(value);
            if (!aesPrefix.equals(valuePrefixArray[1])) break block7;
            String result = ReencryptUtils.legacyDeobfuscation(valuePrefixArray[0]);
            Object newEncryptedValue = Obfuscator.obfuscate(result);
            newEncryptedValue = ReencryptUtils.getNewPrefix(valuePrefixArray[1]) + (String)newEncryptedValue;
            return new Replacement(value, (String)newEncryptedValue);
            {
                catch (ObfuscationException obfuscationException) {
                    return null;
                }
            }
        }
        try {
            byte[] deobfuscated = ReencryptUtils.deobfuscate(valuePrefixArray[0], decryptionKeySet);
            boolean isOriginalCompressed = ReencryptUtils.isCompressedJwe(value);
            Object newEncryptedValue = Obfuscator.obfuscateBinary(deobfuscated, isOriginalCompressed);
            if (valuePrefixArray[1] != null) {
                newEncryptedValue = ReencryptUtils.getNewPrefix(valuePrefixArray[1]) + (String)newEncryptedValue;
            }
            return new Replacement(value, (String)newEncryptedValue);
        }
        catch (ObfuscationException e) {
            String result = ReencryptUtils.legacyDeobfuscation(valuePrefixArray[0]);
            if (ReencryptUtils.isValidPlainText(result)) {
                return new Replacement(true);
            }
            throw new ObfuscationException("Could not decrypt");
        }
    }

    public static String getKeyUsedToEncrypt(String value) {
        String[] valuePrefixArray = ReencryptUtils.handlePrefix(value);
        String jweCandidate = valuePrefixArray[0];
        JsonWebEncryption jwe = new JsonWebEncryption();
        try {
            jwe.setCompactSerialization(jweCandidate);
        }
        catch (JoseException e) {
            return null;
        }
        return jwe.getKeyIdHeaderValue();
    }

    public static String[] handlePrefix(String value) {
        if (value.startsWith(obfJwePrefix)) {
            String normalizedValue = value.replaceFirst(obfJwePrefix, "");
            return new String[]{normalizedValue, obfJwePrefix};
        }
        if (value.startsWith(hsmPrefix)) {
            String normalizedValue = value.replaceFirst(hsmPrefix, "");
            return new String[]{normalizedValue, hsmPrefix};
        }
        if (value.startsWith(aesPrefix)) {
            String normalizedValue = value.replaceFirst(aesPrefix, "");
            return new String[]{normalizedValue, aesPrefix};
        }
        return new String[]{value, null};
    }

    public static String getNewPrefix(String originalPrefix) {
        if (obfJwePrefix.equals(originalPrefix) || hsmPrefix.equals(originalPrefix)) {
            return originalPrefix;
        }
        if (aesPrefix.equals(originalPrefix)) {
            return obfJwePrefix;
        }
        return originalPrefix;
    }

    public static void performReencryption(List<ReencryptionTarget> targets) throws IOException {
        if (!targets.isEmpty()) {
            log.info("Performing file reencryption with key " + ReencryptUtils.getCurrentKeyId());
            for (ReencryptionTarget rt : targets) {
                String fileContents = new String(Files.readAllBytes(rt.getFile().toPath()), StandardCharsets.UTF_8);
                for (Replacement replacement : rt.getEncryptedFields()) {
                    fileContents = fileContents.replace(replacement.originalValue, replacement.replacementValue);
                }
                Updater updater = UpdaterFactory.getUpdaterForFile(rt.getFile());
                fileContents = updater.update(fileContents);
                log.trace("Saving " + ReencryptUtils.getRelativeFilePath(rt.getFile().getPath()));
                FileUtils.writeStringToFile((File)rt.getFile(), (String)fileContents, (Charset)null);
            }
        }
    }

    public static byte[] deobfuscate(String obfuscatedText, JsonWebKeySet decryptionKeySet) {
        byte[] deobfuscated = CryptoUtil.jweDeobfuscateBinary((String)obfuscatedText, (JsonWebKeySet)decryptionKeySet);
        if (deobfuscated == null) {
            throw new ObfuscationException("Could not decrypt");
        }
        return deobfuscated;
    }

    public static String legacyDeobfuscation(String obfuscatedText) {
        String result = CryptoUtil.deobfuscate((String)obfuscatedText, (String)"AES");
        if (ReencryptUtils.isValidPlainText(result)) {
            return result;
        }
        return null;
    }

    public static boolean isValidPlainText(String result) {
        return StringUtils.isNotEmpty((String)result);
    }

    public static boolean isCompressedJwe(String value) {
        JsonWebEncryption jwe = new JsonWebEncryption();
        try {
            jwe.setCompactSerialization(value);
            String compressionHeader = jwe.getCompressionAlgorithmHeaderParameter();
            if ("DEF".equalsIgnoreCase(compressionHeader)) {
                return true;
            }
        }
        catch (JoseException e) {
            return false;
        }
        return false;
    }

    public static String getRelativeFilePath(String fileStr) {
        String pfRootDir = MgmtFactory.getSysDirInfo().getRootDir();
        return ReencryptUtils.getRelativeFilePath(pfRootDir, fileStr);
    }

    public static String getRelativeFilePath(String pfRootPath, String fileStr) {
        try {
            Path basePath = new File(pfRootPath).getCanonicalFile().toPath();
            Path filePath = new File(fileStr).getCanonicalFile().toPath();
            return basePath.relativize(filePath).toString();
        }
        catch (IOException e) {
            return fileStr;
        }
    }

    public static FileScanner getFileScanner(File file) {
        return ReencryptUtils.getFileScanner(file.getName());
    }

    public static FileScanner getFileScanner(String fileName, JsonWebKeySet decryptionKeySet) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (extension.equals("xml")) {
            return new XmlFileScanner(decryptionKeySet);
        }
        if (extension.equals("conf") || extension.equals("properties")) {
            return new PropertiesFileScanner(decryptionKeySet);
        }
        if (extension.equals("txt")) {
            return new TextFileScanner(decryptionKeySet);
        }
        if (extension.equals("jwks")) {
            return new JsonFileScanner(decryptionKeySet);
        }
        return null;
    }

    public static FileScanner getFileScanner(String fileName) {
        JsonWebKeySet decryptionKeySet = MgmtFactory.getMasterKeySet().getJsonWebKeySet();
        return ReencryptUtils.getFileScanner(fileName, decryptionKeySet);
    }

    public static String getCurrentKeyId() {
        return ((JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0)).getKeyId();
    }
}

