/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption;

import com.pingidentity.reencryption.Updater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexUpdater
implements Updater {
    private final Pattern pattern;
    private final String replacementString;
    private final ReplacementStrategy replacementStrategy;

    public RegexUpdater(Pattern pattern, String replacementString, ReplacementStrategy replacementStrategy) {
        this.pattern = pattern;
        this.replacementString = replacementString;
        this.replacementStrategy = replacementStrategy;
    }

    @Override
    public String update(String content) {
        Matcher matcher = this.pattern.matcher(content);
        switch (this.replacementStrategy) {
            case ALL: {
                return matcher.replaceAll(this.replacementString);
            }
            case FIRST: {
                return matcher.replaceFirst(this.replacementString);
            }
        }
        throw new IllegalStateException("Default is not allowed");
    }

    public static enum ReplacementStrategy {
        FIRST,
        ALL;

    }
}

