/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption.filescanner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ValueHandler;
import com.pingidentity.reencryption.filescanner.FileScanner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwk.JsonWebKeySet;
import org.sourceid.util.ObjectMapperFactory;

public class JsonFileScanner
implements FileScanner {
    private static final Logger log = LogManager.getLogger(JsonFileScanner.class);
    private final JsonWebKeySet decryptionKeySet;
    private final ObjectMapper objectMapper;

    public JsonFileScanner(JsonWebKeySet decryptionKeySet) {
        this.decryptionKeySet = decryptionKeySet;
        this.objectMapper = ObjectMapperFactory.buildObjectMapper();
    }

    @Override
    public Object scanFile(File file, ValueHandler valueHandler) {
        valueHandler.initialize(file, this.decryptionKeySet);
        String fileName = ReencryptUtils.getRelativeFilePath(file.getPath());
        try {
            byte[] bytes = Files.readAllBytes(file.toPath());
            return this.performScan(fileName, bytes, valueHandler);
        }
        catch (IOException e) {
            String errorMessage = "Error reading the JWKS file: " + ReencryptUtils.getRelativeFilePath(file.getPath());
            log.error(errorMessage);
            log.debug(errorMessage, (Throwable)e);
            return valueHandler.getResult();
        }
    }

    @Override
    public Object scanData(String fileName, byte[] data, ValueHandler valueHandler) {
        valueHandler.initialize(fileName, this.decryptionKeySet);
        try {
            return this.performScan(fileName, data, valueHandler);
        }
        catch (IOException e) {
            String errorMessage = "Error reading the JWKS file: " + fileName;
            log.error(errorMessage);
            log.debug(errorMessage, (Throwable)e);
            return valueHandler.getResult();
        }
    }

    private Object performScan(String fileName, byte[] bytes, ValueHandler valueHandler) throws IOException {
        log.trace("Scanning JWKS file " + fileName);
        JsonNode jsonNode = this.objectMapper.readTree(new String(bytes, StandardCharsets.UTF_8));
        this.decryptJSON(jsonNode, valueHandler);
        return valueHandler.getResult();
    }

    private void decryptJSON(JsonNode jsonNode, ValueHandler valueHandler) {
        Iterator keys = jsonNode.fieldNames();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.handleJSONValue(jsonNode.get(key), valueHandler);
        }
    }

    private void handleJSONValue(JsonNode jsonNode, ValueHandler valueHandler) {
        if (jsonNode.isTextual()) {
            valueHandler.processValue(jsonNode.asText());
        } else if (jsonNode.isObject()) {
            this.decryptJSON(jsonNode, valueHandler);
        } else if (jsonNode.isArray()) {
            for (JsonNode arrayNode : jsonNode) {
                this.handleJSONValue(arrayNode, valueHandler);
            }
        }
    }
}

