/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption.filescanner;

import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ValueHandler;
import com.pingidentity.reencryption.filescanner.FileScanner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwk.JsonWebKeySet;

public class PropertiesFileScanner
implements FileScanner {
    private static final Logger log = LogManager.getLogger(PropertiesFileScanner.class);
    JsonWebKeySet decryptionKeySet;

    public PropertiesFileScanner(JsonWebKeySet decryptionKeySet) {
        this.decryptionKeySet = decryptionKeySet;
    }

    @Override
    public Object scanFile(File file, ValueHandler valueHandler) {
        Object object;
        valueHandler.initialize(file, this.decryptionKeySet);
        String fileName = ReencryptUtils.getRelativeFilePath(file.getPath());
        FileInputStream inputStream = new FileInputStream(file);
        try {
            object = this.performScan(fileName, inputStream, valueHandler);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String errorMessage = "Error reading the properties file: " + ReencryptUtils.getRelativeFilePath(file.getPath());
                log.error(errorMessage);
                log.debug(errorMessage, (Throwable)e);
                return valueHandler.getResult();
            }
        }
        ((InputStream)inputStream).close();
        return object;
    }

    @Override
    public Object scanData(String fileName, byte[] data, ValueHandler valueHandler) {
        valueHandler.initialize(fileName, this.decryptionKeySet);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            return this.performScan(fileName, inputStream, valueHandler);
        }
        catch (IOException e) {
            String errorMessage = "Error reading the properties file: " + fileName;
            log.error(errorMessage);
            log.debug(errorMessage, (Throwable)e);
            return valueHandler.getResult();
        }
    }

    private Object performScan(String fileName, InputStream inputStream, ValueHandler valueHandler) throws IOException {
        log.trace("Scanning properties file " + fileName);
        Properties props = new Properties();
        props.load(inputStream);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String value = props.getProperty(propertyName);
            valueHandler.processValue(value);
        }
        return valueHandler.getResult();
    }
}

