/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.resilience;

import com.pingidentity.resilience.FailureThresholdAction;
import com.pingidentity.resilience.FailureThresholdMonitor;
import com.pingidentity.resilience.NoOpFailureThresholdAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class SlidingWindowThresholdMonitor
implements FailureThresholdMonitor {
    private final int slidingWindowInSeconds;
    private final double thresholdPercent;
    private final FailureThresholdAction action;
    private boolean thresholdExceeded = false;
    final List<Event> events = new LinkedList<Event>();

    public SlidingWindowThresholdMonitor(int slidingWindowInSeconds, double thresholdPercent, FailureThresholdAction action) {
        this.slidingWindowInSeconds = slidingWindowInSeconds;
        this.thresholdPercent = thresholdPercent;
        this.action = Objects.requireNonNullElseGet(action, NoOpFailureThresholdAction::new);
    }

    @Override
    public synchronized void success() {
        this.events.add(new Event(EventType.SUCCESS));
        this.checkThreshold();
    }

    @Override
    public synchronized void failure() {
        this.events.add(new Event(EventType.FAILURE));
        this.checkThreshold();
    }

    private void checkThreshold() {
        if (this.isThresholdExceeded()) {
            if (!this.thresholdExceeded) {
                this.action.thresholdExceeded(this.getCurrentInfo());
            }
            this.thresholdExceeded = true;
        } else {
            if (this.thresholdExceeded) {
                this.action.thresholdCleared(this.getCurrentInfo());
            }
            this.thresholdExceeded = false;
        }
    }

    @Override
    public synchronized boolean isThresholdExceeded() {
        long windowStartTime = System.currentTimeMillis() - (long)this.slidingWindowInSeconds * 1000L;
        this.events.removeIf(event -> event.isExpired(windowStartTime));
        return this.currentFailurePercent() > this.thresholdPercent;
    }

    double currentFailurePercent() {
        if (this.events.isEmpty()) {
            return 0.0;
        }
        long failureCount = this.events.stream().filter(event -> event.type == EventType.FAILURE).count();
        return (double)failureCount / (double)this.events.size() * 100.0;
    }

    @Override
    public FailureThresholdAction.ThresholdInfo getCurrentInfo() {
        return new FailureThresholdAction.ThresholdInfo(this.currentFailurePercent(), this.thresholdPercent, this.slidingWindowInSeconds);
    }

    private static enum EventType {
        SUCCESS,
        FAILURE;

    }

    private static class Event {
        private final long timestamp = System.currentTimeMillis();
        private final EventType type;

        public Event(EventType type) {
            this.type = type;
        }

        public boolean isExpired(long windowTimestamp) {
            return this.timestamp < windowTimestamp;
        }
    }
}

