/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.hivemind.AutoReloadableServiceProxy;
import com.pingidentity.sdk.internal.services.interfaces.ConfigCacheService;
import com.pingidentity.sdk.util.ConfigCache;
import java.util.function.Supplier;

public class ConfigCacheServiceImpl
implements ConfigCacheService {
    public <ConfigType> ConfigCache.ConfigHolder<ConfigType> makeConfigHolderProxy(Supplier<ConfigType> configSupplier) {
        return AutoReloadableServiceProxy.makeProxy(ConfigCache.ConfigHolder.class, () -> new ConfigHolderImpl(configSupplier));
    }

    private static class ConfigHolderImpl<ConfigType>
    implements ConfigCache.ConfigHolder<ConfigType>,
    AutoReloadable {
        private final Supplier<ConfigType> configSupplier;
        private volatile ConfigType cachedConfig;

        public ConfigHolderImpl(Supplier<ConfigType> configSupplier) {
            this.configSupplier = configSupplier;
            this.cachedConfig = configSupplier.get();
        }

        public ConfigType get() {
            if (this.cachedConfig == null) {
                this.cachedConfig = this.configSupplier.get();
            }
            return this.cachedConfig;
        }

        public void clear() {
            this.cachedConfig = null;
        }
    }
}

