/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.sdk.internal.services.interfaces.ConnectionAccessorService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConnectionAccessorServiceImpl
implements ConnectionAccessorService {
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();

    public Map<String, ParamValues> getSpConnectionExtendedProperties(String entityId) {
        SpConnection spConnection = this.connectionManager.getSpConnection(entityId);
        if (spConnection == null) {
            return Map.of();
        }
        return spConnection.getExtendedProperties();
    }

    public Map<String, List<String>> getSpConnectionExtendedPropertyValues(String entityId) {
        SpConnection spConnection = this.connectionManager.getSpConnection(entityId);
        if (spConnection == null) {
            return Map.of();
        }
        return spConnection.getExtendedProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (e.getValue() == null || ((ParamValues)e.getValue()).getElements() == null) {
                return Collections.emptyList();
            }
            return ((ParamValues)e.getValue()).getElements();
        }));
    }
}

