/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.config.xml.ldapds.LdapSource;
import com.pingidentity.sdk.internal.services.interfaces.DataSourceAccessorService;
import com.pingidentity.sources.CustomDataSourceDriver;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DataSourceAccessorServiceImpl
implements DataSourceAccessorService {
    private final DataSourceManager dsManager = MgmtFactory.getDataSourceManager();

    public LdapInfo getLdapInfo(String ldapId) {
        LdapDataSource ldapSource = this.dsManager.getLdapDataSource(ldapId);
        return ldapSource == null ? null : ldapSource.getLdapInfoClone();
    }

    public void populateDefaultPoolOptions(LdapInfo ldapInfo) {
        LdapSource ldapDataSourceXmlBean = LdapSource.Factory.newInstance();
        ldapInfo.setTestOnBorrow(ldapDataSourceXmlBean.getTestOnBorrow());
        ldapInfo.setTestOnReturn(ldapDataSourceXmlBean.getTestOnReturn());
        ldapInfo.setCreateIfNecessary(ldapDataSourceXmlBean.getCreateIfNecessary());
        ldapInfo.setRetryFailedOperations(ldapDataSourceXmlBean.getRetryFailedOperations());
        ldapInfo.setMin(ldapDataSourceXmlBean.getMinIdle());
        ldapInfo.setMax(ldapDataSourceXmlBean.getMaxActive());
        ldapInfo.setMaxWait(ldapDataSourceXmlBean.getMaxWait());
        ldapInfo.setTimeBetweenEvictionRunsMillis(ldapDataSourceXmlBean.getTimeBetweenEvictionRunsMillis());
        ldapInfo.setReadTimeoutMillis(ldapDataSourceXmlBean.getReadTimeoutMillis());
        ldapInfo.setConnTimeoutMillis(ldapDataSourceXmlBean.getConnTimeoutMillis());
        ldapInfo.setVerifyHost(ldapDataSourceXmlBean.getVerifyHost());
        ldapInfo.setDnsTtlMillis(ldapDataSourceXmlBean.getDnsTtlMillis());
        ldapInfo.setLdapDnsSrvPrefix(ldapDataSourceXmlBean.getLdapDnsSrvPrefix());
        ldapInfo.setLdapsDnsSrvPrefix(ldapDataSourceXmlBean.getLdapsDnsSrvPrefix());
        ldapInfo.setUseLdapReferral(ldapDataSourceXmlBean.getAdReferral());
    }

    public CustomDataSourceDriver getCustomDataSourceDriver(String sourceId) {
        CustomDataSource customSource = this.dsManager.getCustomDataSource(sourceId);
        if (customSource == null) {
            return null;
        }
        this.dsManager.loadCustomDataSourceDriver(customSource);
        return customSource.getDriver();
    }
}

