/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneEnvironment;
import com.pingidentity.sdk.internal.services.interfaces.FilterableSearchFieldService;
import com.pingidentity.sdk.util.AuthnSourceKeyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.adapter.gui.AuthnSourceSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.OAuthClientSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PolicyContractFieldDescriptor;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;

public class FilterableSearchFieldServiceImpl
implements FilterableSearchFieldService {
    private final MetadataDirectory metadataDirectory = MgmtFactory.getMetadataDirectory();
    private final C2cContractManager c2cContractManager = MgmtFactory.getC2cContractManager();
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final PingOneConnectionsManager pingOneConnectionsManager = MgmtFactory.getPingOneConnectionsManager();

    public String getDisplayNameForStorage(String valueForStorage, FilterableSelectionFieldDescriptor descriptor) {
        if (descriptor instanceof OAuthClientSelectionFieldDescriptor) {
            return this.getClientDisplayForStorageId(valueForStorage, ((OAuthClientSelectionFieldDescriptor)descriptor).getIncludeGrantTypeSet());
        }
        if (descriptor instanceof PingOneEnvironmentFieldDescriptor) {
            return this.getPingOneEnvironmentDisplayForStorage(valueForStorage);
        }
        if (descriptor instanceof PolicyContractFieldDescriptor) {
            return this.getApcDisplayName(valueForStorage);
        }
        if (descriptor instanceof AuthnSourceSelectionFieldDescriptor) {
            return AuthnSourceKeyUtil.getAuthnSourceKeyDisplayForStorage(valueForStorage);
        }
        throw new NotImplementedException("Unable to retrieve the proper display name. Unexpected filterable selection field type '" + descriptor.getClass() + "'");
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes(FilterableSelectionFieldDescriptor descriptor) {
        if (descriptor instanceof PingOneEnvironmentFieldDescriptor) {
            return this.getPingOneSearchableTypes();
        }
        throw new NotImplementedException("Unable to retrieve searchable types. Unexpected filterable selection field type '" + descriptor.getClass() + "'");
    }

    public String getConnectionDisplayFromStorageId(String storageId, String connectionType) {
        ConnectionBase connection = null;
        connection = connectionType.equals(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION.name()) ? this.metadataDirectory.getIdpConnectionBySystemId(storageId, true) : this.metadataDirectory.getSpConnectionBySystemId(storageId, true);
        return this.getDisplayValueFromConnectionBase(connection);
    }

    public String getConnectionStorageIdFromSearchableId(String searchableId, String connectionType) {
        ConnectionBase connection = null;
        connection = connectionType.equals(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION.name()) ? this.metadataDirectory.getIdpConnection(searchableId, true) : this.metadataDirectory.getSpConnection(searchableId, true);
        return connection.getId();
    }

    private String getApcDisplayName(String apcId) {
        C2cContract apc = this.c2cContractManager.getContract(apcId);
        return apc != null ? apc.getName() : "";
    }

    private boolean containValidGrantTypes(Client client, Set<String> includeGrantTypeSet) {
        for (String grantType : client.getGrantTypes()) {
            if (!includeGrantTypeSet.contains(grantType)) continue;
            return true;
        }
        return includeGrantTypeSet.isEmpty();
    }

    private String getClientDisplayForStorageId(String valueForStorage, Set<String> validGrantTypes) {
        Client client = this.clientManager.getClient(valueForStorage);
        if (client != null && this.containValidGrantTypes(client, validGrantTypes)) {
            return String.format("%s (%s)", client.getName(), valueForStorage);
        }
        return "";
    }

    private List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getPingOneSearchableTypes() {
        ArrayList<PingOneConnection> connections = new ArrayList<PingOneConnection>(this.pingOneConnectionsManager.getAllConnections());
        ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig> configs = new ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig>();
        for (PingOneConnection conn : connections) {
            String endpoint = "/pingOneConnections/" + conn.getId() + "/environments";
            FilterableSelectionFieldDescriptor.SearchableType searchableType = new FilterableSelectionFieldDescriptor.SearchableType("PINGONE_CONNECTION_" + conn.getId(), conn.getName(), endpoint, "id", "name");
            FilterableSelectionFieldDescriptor.SearchableTypeConfig config = new FilterableSelectionFieldDescriptor.SearchableTypeConfig(searchableType, Collections.emptyList(), conn.getId());
            configs.add(config);
        }
        return configs;
    }

    private String getPingOneEnvironmentDisplayForStorage(String valueForStorage) {
        if (!StringUtils.isEmpty((CharSequence)valueForStorage)) {
            String connId = PingOneEnvironmentFieldDescriptor.getConnectionId((String)valueForStorage);
            String envId = PingOneEnvironmentFieldDescriptor.getEnvironmentId((String)valueForStorage);
            PingOneConnection connection = this.pingOneConnectionsManager.getConnection(connId);
            if (connection != null) {
                String envName = "";
                try {
                    for (PingOneEnvironment env : connection.getEnvironments(false)) {
                        if (!envId.equals(env.getId())) continue;
                        envName = env.getName();
                    }
                }
                catch (InvalidGatewayCredentialException e) {
                    return "Invalid PingOne connection credentials";
                }
                catch (IOException e) {
                    return "Unable to reach PingOne";
                }
                if (!StringUtils.isEmpty((CharSequence)envName)) {
                    return connection.getName() + " - " + envName;
                }
            }
        }
        return "";
    }

    private String getDisplayValueFromConnectionBase(ConnectionBase connectionBase) {
        return String.format("%s (%s)", connectionBase.getName() + (connectionBase.isActive() ? "" : " - Inactive"), connectionBase.getEntityId());
    }
}

