/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.sdk.internal.services.interfaces.SelectFieldDescriptionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CaptchaProviderFieldDescriptor;
import org.sourceid.saml20.adapter.gui.NotificationSenderFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.CaptchaProviderPluginManager;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class SelectFieldDescriptionServiceImpl
implements SelectFieldDescriptionService {
    private final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
    private final CaptchaProviderPluginManager captchaProviderPluginManager = MgmtFactory.getCaptchaProviderPluginManager();
    private final NotificationPublisherPluginManager notificationMgr = MgmtFactory.getNotificationPublisherPluginManager();
    private final PasswordCredentialValidatorManager pwcMgr = MgmtFactory.getCredentialValidatorManager();
    private final KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();

    public List<AbstractSelectionFieldDescriptor.OptionValue> getBearerAccessTokenOptionValues() {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> result = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        result.add(SelectFieldDescriptor.SELECT_ONE);
        for (BearerAccessTokenMgmtPluginInstance instance : this.bearerAccessTokenMgmtPluginMgr.getInstances()) {
            result.add(new AbstractSelectionFieldDescriptor.OptionValue(instance.getName(), instance.getId()));
        }
        return result;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getCaptchaProviderOptionValues() {
        LinkedList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new LinkedList<AbstractSelectionFieldDescriptor.OptionValue>();
        if (this.captchaProviderPluginManager.getDefaultInstance() == null && this.captchaProviderPluginManager.getInstances().isEmpty()) {
            optionValues.add(SelectFieldDescriptor.SELECT_ONE);
            return optionValues;
        }
        for (ConfigurablePluginInstance pluginInstance : this.captchaProviderPluginManager.getInstances()) {
            String optionName = pluginInstance.getName();
            String value = pluginInstance.getId();
            optionValues.add(new AbstractSelectionFieldDescriptor.OptionValue(optionName, value));
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, CaptchaProviderFieldDescriptor.DEFAULT);
        return optionValues;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getCustomDataSourceOptionValues() {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        Collection<CustomDataSource> custDataSources = this.dataSourceManager.getCustomDataSources();
        for (CustomDataSource ds : custDataSources) {
            String description = ds.getDescription();
            String id = ds.getId();
            AbstractSelectionFieldDescriptor.OptionValue ov = new AbstractSelectionFieldDescriptor.OptionValue(description, id);
            optionValues.add(ov);
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
        return optionValues;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getJdbcDataSourceOptionValues() {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        Collection<JdbcDataSource> jdbcDataSources = this.dataSourceManager.getJdbcDataSources();
        for (JdbcDataSource ds : jdbcDataSources) {
            String description = ds.getDescription();
            String jndiName = ds.getJndiName();
            AbstractSelectionFieldDescriptor.OptionValue ov = new AbstractSelectionFieldDescriptor.OptionValue(description, jndiName);
            optionValues.add(ov);
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
        return optionValues;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getLdapAuthenticationErrorOptionValues() {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        for (AuthenticationResultEnum resultEnum : AuthenticationResultEnum.values()) {
            String value = resultEnum.getId();
            String optionName = resultEnum.getDisplayName();
            if (optionName == null) continue;
            AbstractSelectionFieldDescriptor.OptionValue ov = new AbstractSelectionFieldDescriptor.OptionValue(optionName, value);
            optionValues.add(ov);
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
        optionValues.add(new AbstractSelectionFieldDescriptor.OptionValue("Use Message Properties Key", "use.message.properties.key"));
        return optionValues;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getLdapDatastoreOptionValues() {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        Collection<LdapDataSource> ldapDataSources = this.dataSourceManager.getLdapDataSources();
        for (LdapDataSource ds : ldapDataSources) {
            String description = ds.getDescription();
            String jndiName = ds.getId();
            AbstractSelectionFieldDescriptor.OptionValue ov = new AbstractSelectionFieldDescriptor.OptionValue(description, jndiName);
            optionValues.add(ov);
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
        return optionValues;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getNotificationSenderOptionValues() {
        LinkedList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new LinkedList<AbstractSelectionFieldDescriptor.OptionValue>();
        if (this.notificationMgr.getDefaultInstance() == null && this.notificationMgr.getInstances().isEmpty()) {
            optionValues.add(SelectFieldDescriptor.SELECT_ONE);
            return optionValues;
        }
        for (ConfigurablePluginInstance pluginInstance : this.notificationMgr.getInstances()) {
            String optionName = pluginInstance.getName();
            String value = pluginInstance.getId();
            optionValues.add(new AbstractSelectionFieldDescriptor.OptionValue(optionName, value));
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, NotificationSenderFieldDescriptor.DEFAULT);
        return optionValues;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getPasswordCredentialValidatorOptionValues() {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        for (ConfigurablePluginInstance pluginInstance : this.pwcMgr.getInstances()) {
            String value = pluginInstance.getId();
            String optionName = pluginInstance.getName();
            AbstractSelectionFieldDescriptor.OptionValue ov = new AbstractSelectionFieldDescriptor.OptionValue(optionName, value);
            optionValues.add(ov);
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
        return optionValues;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getKerberosRealmOptionValues() {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        for (KerberosRealm kerberosRealm : this.kerberosRealmManager.getKerberosRealms()) {
            String realmName = kerberosRealm.getKerberosRealmName();
            String realmId = kerberosRealm.getId();
            AbstractSelectionFieldDescriptor.OptionValue ov = new AbstractSelectionFieldDescriptor.OptionValue(realmName, realmId);
            optionValues.add(ov);
        }
        optionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
        optionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
        return optionValues;
    }
}

