/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.sdk.internal.services.interfaces.SessionManagerService;
import java.security.InvalidParameterException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.service.SessionRevocationService;
import org.sourceid.saml20.service.session.StoredSessionService;
import org.sourceid.saml20.service.session.data.SessionStorageException;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.servlet.SessionIdUtil;

public class SessionManagerServiceImpl
implements SessionManagerService {
    private static final Logger logger = LoggerFactory.getLogger(SessionManagerServiceImpl.class);
    private final SessionRevocationService sessionRevocationService;
    private final StoredSessionService storedSessionService;

    public SessionManagerServiceImpl() {
        this(StateMgmtFactory.getSessionRevocationService(), StateMgmtFactory.getStoredSessionService());
    }

    public SessionManagerServiceImpl(SessionRevocationService sessionRevocationService, StoredSessionService storedSessionService) {
        this.sessionRevocationService = sessionRevocationService;
        this.storedSessionService = storedSessionService;
    }

    public void revokeAllSessionsFor(String uniqueUserKey) {
        IdpSessionRegistrySupport.revokeSessionsByUserKey(uniqueUserKey, null);
    }

    public void revokeOtherSessionsFor(String uniqueUserKey, HttpServletRequest req, HttpServletResponse resp) {
        String currentSessionExtendedSri = SessionIdUtil.getInstance().getExtendedSriV2(req, resp, null);
        IdpSessionRegistrySupport.revokeSessionsByUserKey(uniqueUserKey, currentSessionExtendedSri);
    }

    public void revoke(String sri) {
        ExtendedSri extendedSri;
        try {
            extendedSri = new ExtendedSri(sri);
        }
        catch (InvalidParameterException e) {
            logger.warn("Could not revoke SRI - Invalid SRI '{}'.", (Object)sri);
            return;
        }
        AuditLogger.setExtendedSri(extendedSri);
        this.sessionRevocationService.addRevokedSri(extendedSri.getSri());
        IdpAuditLogger.logSessionRevocation("SRI Revoked");
        if (extendedSri.getPersistentSessionGroupId() != null) {
            this.sessionRevocationService.addRevokedSri(extendedSri.getPersistentSessionGroupId());
            try {
                this.storedSessionService.deleteAuthnSessions(Set.of(extendedSri.getPersistentSessionGroupId()));
                return;
            }
            catch (SessionStorageException e) {
                logger.error("Error deleting authn sessions for persistent session group id '{}'.", (Object)extendedSri.getPersistentSessionGroupId(), (Object)e);
            }
        }
    }
}

