/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.sdk.internal.services.interfaces.XmlHelperService;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.xmlbinding.protocol.ExtensionsType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;

public class XmlHelperServiceImpl
implements XmlHelperService {
    public XmlObject addToSaml2Extensions(XmlObject targetDocument, String xml) {
        ExtensionsType extensions;
        XmlObject typeXmlObj = XmlBeansUtil.unwrapDocumentToType(targetDocument);
        if (typeXmlObj instanceof RequestAbstractType) {
            RequestAbstractType reqAbsType = (RequestAbstractType)typeXmlObj;
            extensions = reqAbsType.isSetExtensions() ? reqAbsType.getExtensions() : reqAbsType.addNewExtensions();
        } else if (typeXmlObj instanceof StatusResponseType) {
            StatusResponseType statusRespType = (StatusResponseType)typeXmlObj;
            extensions = statusRespType.isSetExtensions() ? statusRespType.getExtensions() : statusRespType.addNewExtensions();
        } else {
            throw new IllegalArgumentException("Can only add extensions to SAML 2.0 RequestAbstractType or StatusResponseType but received " + targetDocument);
        }
        XmlObject xmlObject = this.parse(xml);
        return this.addAsLastChild((XmlObject)extensions, xmlObject);
    }

    public void setAttribute(XmlObject target, String attributeName, String attributeValue) {
        XmlBeansUtil.setAttributeValue(target, attributeValue, attributeName);
    }

    public void setAttribute(XmlObject target, String attributeNamespace, String attributeName, String attributeValue) {
        XmlBeansUtil.setAttributeValue(target, attributeValue, attributeNamespace, attributeName);
    }

    public XmlObject parse(String xml) {
        try {
            XmlObject parse = XmlBeansUtil.parse(xml, XmlObject.class);
            return XmlBeansUtil.getFirstChild(parse);
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("Unable to process the given XML string " + xml, e);
        }
    }

    public XmlObject addAsLastChild(XmlObject target, XmlObject child) {
        XmlBeansUtil.setChildren(target, child);
        List<XmlObject> children = XmlBeansUtil.getChildren(target);
        return children.get(children.size() - 1);
    }

    public XmlObject addAsFirstChild(XmlObject target, XmlObject child) {
        XmlBeansUtil.prependChildren(target, child);
        return this.getFirstChild(target);
    }

    public XmlObject getFirstChild(XmlObject xmlObject) {
        return XmlBeansUtil.getFirstChild(xmlObject);
    }

    public List<XmlObject> getChildren(XmlObject xmlObject) {
        return XmlBeansUtil.getChildren(xmlObject);
    }
}

