/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.services;

import com.pingidentity.services.ConfigurationBootstrapService;
import java.io.IOException;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public class ConfigurationBootstrapServiceManager {
    private static final Log log = LogFactory.getLog(ConfigurationBootstrapServiceManager.class);
    private static final String ENV_VAR_ENABLED = "PF_CONFIG_BOOTSTRAP_SERVICE_enabled";
    private static final String ENV_VAR_REPLICATE_ON_SUCCESS = "PF_CONFIG_BOOTSTRAP_SERVICE_replicate_on_success";
    private final Mediator mediator;
    private final AdminNodeConfigManager adminNodeConfigManager;
    private final ServiceLoader<ConfigurationBootstrapService> loader;

    public ConfigurationBootstrapServiceManager(Mediator mediator, AdminNodeConfigManager adminNodeConfigManager) {
        this.mediator = mediator;
        this.adminNodeConfigManager = adminNodeConfigManager;
        boolean isEnabled = Boolean.parseBoolean(System.getenv(ENV_VAR_ENABLED));
        this.loader = isEnabled ? ServiceLoader.load(ConfigurationBootstrapService.class) : null;
    }

    public void applyConfiguration() {
        if (this.loader == null) {
            log.debug((Object)"Configuration bootstrap service is not enabled. Skipping applying bootstrap configurations.");
            return;
        }
        log.info((Object)"Applying bootstrap configurations.");
        if (!this.mediator.isConsole()) {
            log.info((Object)"PF is not a console node. Skipping applying bootstrap configurations.");
            return;
        }
        if (this.adminNodeConfigManager.isEnabledAndPassiveNode()) {
            log.info((Object)"PF is a passive console node. Skipping applying bootstrap configurations.");
            return;
        }
        try {
            if (this.loader.stream().count() > 1L) {
                log.warn((Object)"Multiple configuration bootstrap service Jars found. Skipping applying bootstrap configurations.");
                return;
            }
            Optional<ConfigurationBootstrapService> serviceOptional = this.loader.findFirst();
            if (serviceOptional.isEmpty()) {
                log.info((Object)"Configuration bootstrap service Jar not found. Skipping applying bootstrap configurations.");
                return;
            }
            ConfigurationBootstrapService service = serviceOptional.get();
            log.info((Object)("Processing configuration bootstrap service '" + service.getClass().getName() + "'."));
            ConfigurationBootstrapService.Result result = service.applyConfiguration();
            if (result == ConfigurationBootstrapService.Result.FAILURE) {
                log.error((Object)("Failed processing configuration bootstrap service '" + service.getClass().getName() + "'."));
            } else {
                log.info((Object)("Finished processing configuration bootstrap service '" + service.getClass().getName() + "' with result '" + result + "'."));
            }
            this.replicateIfNecessary(result, this.mediator);
        }
        catch (ServiceConfigurationError e) {
            log.error((Object)"Error encountered loading configuration bootstrap service.", (Throwable)e);
        }
        log.info((Object)"Finished applying bootstrap configurations.");
    }

    private void replicateIfNecessary(ConfigurationBootstrapService.Result result, Mediator mediator) {
        if (mediator.isDistributable() && result == ConfigurationBootstrapService.Result.SUCCESS && Boolean.parseBoolean(System.getenv(ENV_VAR_REPLICATE_ON_SUCCESS))) {
            try {
                log.info((Object)"Replicating after applying bootstrap configurations.");
                mediator.publishConfig();
            }
            catch (IOException e) {
                log.error((Object)"Problem encountered trying to replicate after applying bootstrap configurations. Please address the issue and retry replication.", (Throwable)e);
            }
        }
    }
}

