/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session;

import com.pingidentity.session.AdminSession;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class AdminSessionTracker {
    private static final AdminSessionTracker INSTANCE = new AdminSessionTracker();
    private final Log log = LogFactory.getLog(AdminSessionTracker.class);
    private final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZoneId.systemDefault());
    private final AdminUserManager adminUserManager = MgmtFactory.getAdminUserManager();
    private final Map<String, AdminSession> sessionIdToAdminSessionMap = new HashMap<String, AdminSession>();

    private AdminSessionTracker() {
    }

    public static AdminSessionTracker getInstance() {
        return INSTANCE;
    }

    public synchronized void addAdminSession(HttpSession httpSession, AdministrativeUser adminUser) {
        this.pruneInactiveSessions();
        String hashedSessionId = this.getHashedSessionId(httpSession.getId());
        if (this.sessionIdToAdminSessionMap.containsKey(hashedSessionId)) {
            AdminSession adminSession = this.sessionIdToAdminSessionMap.get(httpSession.getId());
            AdminAuditLogger.setHashedSessionId(adminSession.getHashedSessionId());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Existing admin session found for '" + adminSession.getAdminUserName() + "'."));
            }
        } else {
            AdminAuditLogger.setHashedSessionId(hashedSessionId);
            AdminSession adminSession = new AdminSession(hashedSessionId, httpSession, adminUser);
            this.sessionIdToAdminSessionMap.put(hashedSessionId, adminSession);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Session created: count=" + this.sessionIdToAdminSessionMap.size()));
                this.log.debug((Object)("Admin session created for '" + adminSession.getAdminUserName() + "'."));
            }
        }
    }

    public synchronized void removeSession(HttpSession httpSession) {
        String sessionId;
        String hashedSessionId;
        AdminSession adminSession;
        if (httpSession != null && (adminSession = this.sessionIdToAdminSessionMap.get(hashedSessionId = this.getHashedSessionId(sessionId = httpSession.getId()))) != null) {
            Instant expectedIdleTimeoutEventInstant = this.getExpectedIdleTimeoutInstant(httpSession);
            if (Instant.now().isAfter(expectedIdleTimeoutEventInstant)) {
                AdministrativeUser adminUser;
                try {
                    adminUser = this.adminUserManager.getUser(adminSession.getAdminUserName());
                }
                catch (UnsupportedOperationException ex) {
                    adminUser = adminSession.getAdminUser();
                }
                if (adminUser == null) {
                    adminUser = adminSession.getAdminUser();
                }
                if (adminUser != null) {
                    String expectedIdleTimeoutEventString = this.DATE_TIME_FORMATTER.format(expectedIdleTimeoutEventInstant);
                    AdminAuditLogger.setUser(adminUser.getUserName());
                    AdminAuditLogger.setRoles(new String(adminUser.describeUser(true)));
                    AdminAuditLogger.setHashedSessionId(adminSession.getHashedSessionId());
                    AdminAuditLogger.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.SESSION_TIMEOUT, "Session timed out at " + expectedIdleTimeoutEventString);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Admin session remove called while session has not passed idle timeout period for user '" + adminSession.getAdminUserName() + "'."));
            }
            this.sessionIdToAdminSessionMap.remove(hashedSessionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Session destroyed: count=" + this.sessionIdToAdminSessionMap.size()));
                this.log.debug((Object)("Admin session removed for '" + adminSession.getAdminUserName() + "'."));
            }
        }
    }

    private synchronized void pruneInactiveSessions() {
        List<HttpSession> sessionsToRemove = this.sessionIdToAdminSessionMap.values().stream().map(AdminSession::getHttpSession).filter(httpSession -> Instant.now().isAfter(this.getExpectedIdleTimeoutInstant((HttpSession)httpSession))).collect(Collectors.toList());
        sessionsToRemove.forEach(this::removeSession);
    }

    public synchronized Collection<String> getActiveAdminSessionIds() {
        this.pruneInactiveSessions();
        return this.sessionIdToAdminSessionMap.values().stream().map(adminSession -> adminSession.getHttpSession().getId()).collect(Collectors.toList());
    }

    private Instant getExpectedIdleTimeoutInstant(HttpSession httpSession) {
        Duration expectedIdleTimeout = Duration.ofMillis(httpSession.getLastAccessedTime()).plusSeconds(httpSession.getMaxInactiveInterval());
        return Instant.ofEpochMilli(expectedIdleTimeout.toMillis());
    }

    private String getHashedSessionId(String sessionId) {
        return TokenUtil.digestToken(sessionId);
    }
}

