/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session.quotas.enforcer;

public class QuotaEnforcerResult {
    private final ResultCode resultCode;
    private final boolean denyAccess;

    public QuotaEnforcerResult(ResultCode resultCode, boolean denyAccess) {
        this.resultCode = resultCode;
        this.denyAccess = denyAccess;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public boolean isDenyAccess() {
        return this.denyAccess;
    }

    public static class Builder {
        private boolean denyAccess;
        private ResultCode resultCode;

        public Builder denyAccess(boolean denyAccess) {
            this.denyAccess = denyAccess;
            return this;
        }

        public Builder resultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public QuotaEnforcerResult build() {
            return new QuotaEnforcerResult(this.resultCode, this.denyAccess);
        }
    }

    public static enum ResultCode {
        SUCCESS,
        SKIPPED,
        FAILURE;

    }
}

