/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session.quotas.impl;

import com.pingidentity.sdk.session.SessionQuotaContext;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategy;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategyResult;
import com.pingidentity.session.quotas.SessionQuotaService;
import com.pingidentity.session.quotas.enforcer.QuotaEnforcerResult;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import com.pingidentity.session.quotas.strategy.DenyNewSessionStrategy;
import com.pingidentity.session.quotas.strategy.DestroyIdlestSessionStrategy;
import com.pingidentity.session.quotas.strategy.DestroyOldSessionsStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.sessions.QuotaPolicy;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.SessionRevocationService;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.servlet.ExtendedSri;

public class SessionQuotaServiceImpl
implements SessionQuotaService {
    private static final Logger log = LoggerFactory.getLogger((String)SessionQuotaServiceImpl.class.getName());
    private final AuthnSessionPolicyManager sessionPolicyManager;
    private final SessionRevocationService sessionRevocationService;

    public SessionQuotaServiceImpl(AuthnSessionPolicyManager sessionPolicyManager, SessionRevocationService sessionRevocationService) {
        this.sessionPolicyManager = sessionPolicyManager;
        this.sessionRevocationService = sessionRevocationService;
    }

    @Override
    public QuotaEnforcerResult enforceQuota(SessionQuotaContext context) throws SessionQuotaException {
        QuotaPolicy quotaPolicy = this.getQuotaPolicy();
        List<Object> results = new ArrayList(context.getUserKeySet().size());
        if (quotaPolicy.isEnableSessionQuotas()) {
            for (String userKey : context.getUserKeySet()) {
                log.debug("Enforcing session quota for user {}", (Object)userKey);
                results = this.removeSessions(userKey, context);
            }
            return new QuotaEnforcerResult.Builder().resultCode(QuotaEnforcerResult.ResultCode.SUCCESS).denyAccess(results.stream().anyMatch(SessionQuotaStrategyResult::isDenyAccess)).build();
        }
        return new QuotaEnforcerResult.Builder().resultCode(QuotaEnforcerResult.ResultCode.SKIPPED).denyAccess(false).build();
    }

    private List<SessionQuotaStrategyResult> removeSessions(String userKey, SessionQuotaContext context) throws SessionQuotaException {
        Map<String, AuthnSessionInfo> sessions = this.getActiveSessions(userKey, context);
        ArrayList<SessionQuotaStrategyResult> results = new ArrayList<SessionQuotaStrategyResult>();
        if (this.exceedsQuota(sessions)) {
            IdpAuditLogger.logSessionQuotaExceeded();
            log.info("Quota exceeded for unique user {}. Current number of sessions: {}", (Object)userKey, (Object)sessions.size());
            SessionQuotaStrategy strategy = this.getStrategy();
            boolean continueRemoving = true;
            int maxRemovalAttempts = sessions.size() - this.getQuotaPolicy().getActiveSessionLimit() + 1;
            int removeAttemptCount = 0;
            do {
                SessionQuotaStrategyResult result = strategy.removeSessions(userKey, context, sessions);
                results.add(result);
                if (SessionQuotaStrategyResult.ResultCode.SUCCESS.equals((Object)result.getResultCode()) && !result.isDenyAccess()) {
                    sessions = this.getActiveSessions(userKey, context);
                    continueRemoving = this.exceedsQuota(sessions);
                    if (!continueRemoving) continue;
                    log.debug("Quota still exceeded for user {} after removing sessions. Current number of sessions: {}", (Object)userKey, (Object)sessions.size());
                    continue;
                }
                if (SessionQuotaStrategyResult.ResultCode.FAILED_TO_ENFORCE_QUOTA.equals((Object)result.getResultCode())) {
                    log.warn("Unable to revoke sessions for user {}. Quota enforcement may not be effective. Reason: {}", (Object)userKey, (Object)result.getMessage());
                    throw new SessionQuotaException("Unable to enforce session quota: " + result.getMessage());
                }
                continueRemoving = false;
            } while (continueRemoving && ++removeAttemptCount < maxRemovalAttempts);
        }
        return results;
    }

    private Map<String, AuthnSessionInfo> getActiveSessions(String userKey, SessionQuotaContext quotaContext) {
        Map<String, AuthnSessionInfo> sessions = IdpSessionRegistrySupport.getAuthnSessionInfoByUniqueUserKey(userKey);
        sessions.entrySet().removeIf(entry -> ((String)entry.getKey()).equals(quotaContext.getCurrentSessionExtendedSri()) || this.isSriRevoked((String)entry.getKey()));
        return sessions;
    }

    private boolean isSriRevoked(String sri) {
        ExtendedSri extendedSri = new ExtendedSri(sri);
        return this.sessionRevocationService.getRevokedSriInfo(extendedSri.getSri()) != null;
    }

    private boolean exceedsQuota(Map<String, AuthnSessionInfo> sessionInfo) {
        return sessionInfo.size() >= this.getQuotaPolicy().getActiveSessionLimit();
    }

    private SessionQuotaStrategy getStrategy() {
        QuotaPolicy quotaPolicy = this.getQuotaPolicy();
        switch (quotaPolicy.getQuotaLimitBehavior()) {
            case DESTROY_IDLEST_SESSION: {
                return new DestroyIdlestSessionStrategy();
            }
            case DENY_ACCESS: {
                return new DenyNewSessionStrategy();
            }
            case DESTROY_OLD_SESSIONS: {
                return new DestroyOldSessionsStrategy();
            }
        }
        return new DestroyIdlestSessionStrategy();
    }

    private QuotaPolicy getQuotaPolicy() {
        return this.sessionPolicyManager.getQuotaPolicy();
    }
}

