/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session.quotas.strategy;

import com.pingidentity.sdk.session.SessionQuotaContext;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategy;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategyResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.service.AuthnSessionInfo;

public class DenyNewSessionStrategy
implements SessionQuotaStrategy {
    private static final Logger logger = LoggerFactory.getLogger((String)DenyNewSessionStrategy.class.getName());

    @Override
    public SessionQuotaStrategyResult removeSessions(String userKey, SessionQuotaContext context, Map<String, AuthnSessionInfo> sessions) {
        logger.info("Denying new session creation for {} due to quota limit reached.", (Object)userKey);
        return new SessionQuotaStrategyResult.Builder().denyAccess(true).resultCode(SessionQuotaStrategyResult.ResultCode.SUCCESS).message("No new sessions are allowed for: " + userKey).build();
    }
}

