/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session.quotas.strategy;

import com.pingidentity.sdk.session.SessionManager;
import com.pingidentity.sdk.session.SessionQuotaContext;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategy;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategyResult;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.websso.servlet.SessionIdUtil;

public class DestroyIdlestSessionStrategy
implements SessionQuotaStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DestroyIdlestSessionStrategy.class);

    @Override
    public SessionQuotaStrategyResult removeSessions(String userKey, SessionQuotaContext context, Map<String, AuthnSessionInfo> sessions) {
        if (sessions == null || sessions.isEmpty()) {
            return new SessionQuotaStrategyResult.Builder().denyAccess(false).resultCode(SessionQuotaStrategyResult.ResultCode.SUCCESS).message("No sessions found to remove for " + userKey).build();
        }
        logger.debug("Attempting to remove a session for {} with the oldest last activity time.", (Object)userKey);
        Map.Entry idlestSession = sessions.entrySet().stream().filter(e -> e.getValue() != null && ((AuthnSessionInfo)e.getValue()).getLastActivityTimeMillis() > 0L).min(Comparator.comparingLong(e -> ((AuthnSessionInfo)e.getValue()).getLastActivityTimeMillis())).orElse(null);
        if (idlestSession != null) {
            String extendedSri = SessionIdUtil.getInstance().makeExtendedSriV2WithSri((String)idlestSession.getKey(), ((AuthnSessionInfo)idlestSession.getValue()).getSessionSeriesId(), ((AuthnSessionInfo)idlestSession.getValue()).getPersistentSessionGroupId());
            logger.info("Revoking SRI '{}'for {} as it's the most idle session. Last activity time was {}.", new Object[]{extendedSri, userKey, ((AuthnSessionInfo)idlestSession.getValue()).getLastActivityTimeMillis()});
            SessionManager sessionManager = new SessionManager();
            sessionManager.revoke(extendedSri);
            return new SessionQuotaStrategyResult.Builder().denyAccess(false).resultCode(SessionQuotaStrategyResult.ResultCode.SUCCESS).message("Most idle session successfully removed.").build();
        }
        logger.debug("Did not find SRI for {} with a last activity time to revoke.", (Object)userKey);
        return new SessionQuotaStrategyResult.Builder().denyAccess(false).resultCode(SessionQuotaStrategyResult.ResultCode.FAILED_TO_ENFORCE_QUOTA).message("No SRIs were found to revoke for this strategy").build();
    }
}

