/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.templates.mgmt;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateFileManager
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final Log log = LogFactory.getLog(TemplateFileManager.class);
    private static long templateLastModified;
    private List<File> files = new ArrayList<File>();
    private List<String> unreadableFilesAlreadyLogged = new ArrayList<String>();

    protected List<File> getTemplateFiles(String templateDirPath, boolean includeHiddenFiles) {
        File templateDir = new File(templateDirPath);
        if (!templateDir.canRead()) {
            log.error((Object)("Directory not readable: " + templateDirPath));
            return null;
        }
        if (!templateDir.isDirectory()) {
            log.error((Object)(templateDirPath + " is not a directory."));
            return null;
        }
        long lastModified = templateDir.lastModified();
        if (lastModified > templateLastModified) {
            templateLastModified = lastModified;
            this.updateFilesFromTemplateDir(templateDir);
        }
        return this.fileCacheFilter(includeHiddenFiles);
    }

    private void updateFilesFromTemplateDir(File templateDir) {
        File[] templateFiles = templateDir.listFiles();
        if (templateFiles == null || templateFiles.length == 0) {
            return;
        }
        this.files.clear();
        for (int i = 0; i < templateFiles.length; ++i) {
            File f = templateFiles[i];
            if (!f.isFile()) continue;
            if (!f.canRead()) {
                if (this.unreadableFilesAlreadyLogged.contains(f.getName())) continue;
                log.debug((Object)("File: " + f.getName() + " cannot be read.  Check the permissions on this file."));
                this.unreadableFilesAlreadyLogged.add(f.getName());
                if (this.unreadableFilesAlreadyLogged.size() <= 100) continue;
                this.unreadableFilesAlreadyLogged.clear();
                continue;
            }
            this.files.add(f);
        }
    }

    private List<File> fileCacheFilter(boolean includeHiddenFiles) {
        ArrayList<File> updatedFiles = new ArrayList<File>();
        for (File f : this.files) {
            if (!f.canRead() || f.isHidden() && !includeHiddenFiles) continue;
            updatedFiles.add(f);
        }
        return updatedFiles;
    }
}

