/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class DateUtil {
    public static final String DEFAULT_DATE_PATTERN = "MM/dd/yyyy";

    public static Date convertDate(Date date) {
        if (date == null || new Date(0L).equals(date)) {
            return null;
        }
        return date;
    }

    public static Date calendarToDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        Date date = calendar.getTime();
        if (new Date(0L).equals(date)) {
            return null;
        }
        return date;
    }

    public static Calendar convertCalendar(Calendar calendar) {
        if (calendar != null) {
            return calendar;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(0L));
        return cal;
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return formatter.format(localDate);
    }

    public static Calendar copyCalendar(Calendar calendar) {
        if (calendar != null) {
            return (Calendar)calendar.clone();
        }
        return null;
    }
}

