/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util.documentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.license.LicenseManager;

public class DocumentationHelper {
    protected static final Log log = LogFactory.getLog(DocumentationHelper.class);

    public static String getDocumentationUrl() {
        return DocumentationHelper.getDocumentationConfig().getDocumentationUrl();
    }

    public static String getDocumentationUrl(String context) {
        return String.format("%s&context=%s", DocumentationHelper.getDocumentationUrl(), context);
    }

    public static String getDocumentationJavascript(String context) {
        return String.format("javascript:openContextHelp('%s')", DocumentationHelper.getDocumentationUrl(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentationConfig getDocumentationConfig() {
        DocumentationConfig config = new DocumentationConfig();
        InputStream propertiesFile = null;
        Properties properties = new Properties();
        try {
            ClassLoader classLoader = DocumentationHelper.class.getClassLoader();
            propertiesFile = classLoader.getResourceAsStream("documentation.properties");
            properties.load(propertiesFile);
            if (propertiesFile != null) {
                propertiesFile.close();
            }
            config.setHost(properties.getProperty("documentation.host"));
            config.setProtocol(Boolean.parseBoolean(properties.getProperty("documentation.https.enable")));
            config.setProductVersion(properties.getProperty("documentation.version"));
        }
        catch (IOException e) {
            try {
                log.error((Object)"Missing documentation properties file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(propertiesFile);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)propertiesFile);
        }
        IOUtils.closeQuietly((InputStream)propertiesFile);
        return config;
    }

    private static class DocumentationConfig {
        private boolean https;
        private String host;
        private String productVersion;

        private DocumentationConfig() {
        }

        void setProtocol(boolean isHttps) {
            this.https = isHttps;
        }

        void setHost(String host) {
            this.host = host;
        }

        void setProductVersion(String productVersion) {
            this.productVersion = productVersion;
        }

        String getDocumentationUrl() {
            boolean isBridge = LicenseManager.getLicense().isBridgeMode();
            String version = !isBridge ? this.productVersion : this.productVersion.replaceFirst("^pf-", "pfb-");
            return String.format("%s://%s?Product=%s", this.https ? "https" : "http", this.host, version);
        }
    }
}

