/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util.tls;

import com.pingidentity.crypto.PkCert;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class SingleClientX509KeyManager
implements X509KeyManager {
    private static Log logger = LogFactory.getLog(SingleClientX509KeyManager.class);
    private PrivateKey key;
    private X509Certificate[] certs;
    private String alias;

    public SingleClientX509KeyManager(String alias) {
        this.alias = alias;
        PkCertManager sslManager = MgmtFactory.getSslAuthPkCertManager();
        PkCert pkCert = sslManager.getPkCert(alias);
        this.key = pkCert.getPrivateKey();
        this.certs = pkCert.getChain();
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        if (this.alias.equals(alias)) {
            return this.key;
        }
        logger.warn((Object)("getPrivateKey(" + alias + ") alias mismatch " + this.alias));
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (this.alias.equals(alias)) {
            return Arrays.copyOf(this.certs, this.certs.length);
        }
        logger.warn((Object)("getCertificateChain(" + alias + ") alias mismatch " + this.alias));
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return new String[]{this.alias};
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        throw new UnsupportedOperationException("SingleClientKeyManager does not support server keys! Op: getServerAlias()");
    }

    @Override
    public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
        throw new UnsupportedOperationException("SingleClientKeyManager does not support server keys! Op: chooseServerAlias()");
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket s) {
        String algo = this.key.getAlgorithm();
        for (String keyType : keyTypes) {
            if (!algo.equals(keyType)) continue;
            return this.alias;
        }
        return null;
    }
}

