/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.ws;

import com.pingidentity.ws.AdapterInstanceContextInfo;
import com.pingidentity.ws.ExtAdapterInstanceContextInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.SpConnection;

public class SSODirectoryServiceSupport {
    private static final String PROVIDER_FIELD = "OpenID Provider";
    private static final String DOMAIN_FIELD = "Domain Name";
    private static final SSODirectoryServiceSupport support = new SSODirectoryServiceSupport();

    private SSODirectoryServiceSupport() {
    }

    public static SSODirectoryServiceSupport getInstance() {
        return support;
    }

    List<ExtAdapterInstanceContextInfo> buildListFromSPConnections(Map<IdpAuthnAdapterInstance, List<SpConnection>> idpAdaptersToSpConns) {
        ArrayList<ExtAdapterInstanceContextInfo> connectors = new ArrayList<ExtAdapterInstanceContextInfo>();
        for (Map.Entry<IdpAuthnAdapterInstance, List<SpConnection>> e : idpAdaptersToSpConns.entrySet()) {
            IdpAuthnAdapterInstance instance = e.getKey();
            for (SpConnection spConn : e.getValue()) {
                ExtAdapterInstanceContextInfo connector = new ExtAdapterInstanceContextInfo();
                connector.setAdapterType("IDP_ADAPTER");
                connector.setAdapterInstanceUsageContext("USED_IN_SP_CONNECTION");
                connector.setAdapterId(instance.getId());
                IdpAuthnAdapterDescriptor desc = instance.getDescriptor();
                String className = desc.getAdapterClassName();
                connector.setAdapterClassName(className);
                this.setOpenIdValues(instance, connector);
                connector.setPartnerSpId(spConn.getEntityId());
                connector.setConnectionName(spConn.getName());
                connector.setProtocol(spConn.getProtocol().getProtocolUri());
                connector.setUnambiguousConnectionName(spConn.getName() + "_" + instance.getId() + "_USED_IN_SP_CONNECTION");
                if (StringUtils.isNotBlank((String)spConn.getDefaultTargetResource())) {
                    connector.setTargetResource(spConn.getDefaultTargetResource());
                }
                IndexedEndpoints assertionConsumerIdxEndpoints = spConn.getAssertionConsumerServiceEndpoints();
                connector.setAssertionConsumerBindings(assertionConsumerIdxEndpoints.getBindingsAsCommaDelimList("NA"));
                connector.setAssertionConsumerLocations(assertionConsumerIdxEndpoints.getFullLocationAsCommaDelimList("NA"));
                connector.setAssertionConsumerRespLocations(assertionConsumerIdxEndpoints.getFullResponseLocationAsCommaDelimList("NA"));
                IndexedEndpoints artifactResolutionIdxEndpoints = spConn.getArtifactResolutionServices();
                connector.setArtifactResolutionBindings(artifactResolutionIdxEndpoints.getBindingsAsCommaDelimList("NA"));
                connector.setArtifactResolutionLocations(artifactResolutionIdxEndpoints.getFullLocationAsCommaDelimList("NA"));
                connector.setArtifactResolutionRespLocations(artifactResolutionIdxEndpoints.getFullResponseLocationAsCommaDelimList("NA"));
                connector.setIdpInitSSO(spConn.getEnabledProfiles().isIdpInitiatedSSOEnabled());
                connector.setSpInitSSO(spConn.getEnabledProfiles().isSpInitiatedSSOEnabled());
                connector.setActive(spConn.isActive());
                connectors.add(connector);
            }
        }
        return connectors;
    }

    List<ExtAdapterInstanceContextInfo> buildListFromIdPConnections(Map<AuthnAdapterInstance, List<IdpConnection>> spAdaptersToIdpConns) {
        ArrayList<ExtAdapterInstanceContextInfo> connectors = new ArrayList<ExtAdapterInstanceContextInfo>();
        for (Map.Entry<AuthnAdapterInstance, List<IdpConnection>> e : spAdaptersToIdpConns.entrySet()) {
            AuthnAdapterInstance instance = e.getKey();
            for (IdpConnection idpConn : e.getValue()) {
                ExtAdapterInstanceContextInfo connector = new ExtAdapterInstanceContextInfo();
                connector.setAdapterType("SP_ADAPTER");
                connector.setAdapterInstanceUsageContext("USED_IN_IDP_CONNECTION");
                connector.setAdapterId(instance.getId());
                AuthnAdapterDescriptor desc = instance.getDescriptor();
                String className = desc.getAdapterClassName();
                connector.setAdapterClassName(className);
                connector.setPartnerIdpId(idpConn.getEntityId());
                connector.setConnectionName(idpConn.getName());
                connector.setProtocol(idpConn.getProtocol().getProtocolUri());
                connector.setUnambiguousConnectionName(idpConn.getName() + "_" + instance.getId() + "_USED_IN_IDP_CONNECTION");
                IndexedEndpoints idxEndpoints = idpConn.getArtifactResolutionServices();
                connector.setArtifactResolutionBindings(idxEndpoints.getBindingsAsCommaDelimList("NA"));
                connector.setArtifactResolutionLocations(idxEndpoints.getFullLocationAsCommaDelimList("NA"));
                connector.setArtifactResolutionRespLocations(idxEndpoints.getFullResponseLocationAsCommaDelimList("NA"));
                EndpointGroup singleSignOnServices = idpConn.getSingleSignOnServices();
                connector.setSsoServiceBindings(singleSignOnServices.getBindingsAsCommaDelimList("NA"));
                connector.setSsoServiceLocations(singleSignOnServices.getFullLocationAsCommaDelimList("NA"));
                connector.setSsoServiceRespLocations(singleSignOnServices.getFullResponseLocationAsCommaDelimList("NA"));
                connector.setIdpInitSSO(idpConn.getEnabledProfiles().isIdpInitiatedSSOEnabled());
                connector.setSpInitSSO(idpConn.getEnabledProfiles().isSpInitiatedSSOEnabled());
                connector.setActive(idpConn.isActive());
                connectors.add(connector);
            }
        }
        return connectors;
    }

    List<ExtAdapterInstanceContextInfo> buildListFromA2A(Map<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>> idpAdaptersToA2AMappings) {
        ArrayList<ExtAdapterInstanceContextInfo> connectors = new ArrayList<ExtAdapterInstanceContextInfo>();
        for (Map.Entry<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>> e : idpAdaptersToA2AMappings.entrySet()) {
            IdpAuthnAdapterInstance instance = e.getKey();
            for (Direct2SpAdapterMapping m : e.getValue()) {
                ExtAdapterInstanceContextInfo connector = new ExtAdapterInstanceContextInfo();
                connector.setAdapterType("IDP_ADAPTER");
                connector.setAdapterInstanceUsageContext("USED_IN_ADAPTER_2_ADAPTER");
                connector.setAdapterId(instance.getId());
                IdpAuthnAdapterDescriptor desc = instance.getDescriptor();
                connector.setAdapterClassName(desc.getAdapterClassName());
                connector.setSpSessionAuthnAdapterId(m.getTargetId());
                this.setOpenIdValues(instance, connector);
                connectors.add(connector);
            }
        }
        return connectors;
    }

    List<AdapterInstanceContextInfo> buildCloudConnectorListFromConnections(Map<IdpAuthnAdapterInstance, List<SpConnection>> idpAdaptersToSpConns) {
        ArrayList<AdapterInstanceContextInfo> connectors = new ArrayList<AdapterInstanceContextInfo>();
        for (Map.Entry<IdpAuthnAdapterInstance, List<SpConnection>> e : idpAdaptersToSpConns.entrySet()) {
            IdpAuthnAdapterInstance instance = e.getKey();
            for (SpConnection spConn : e.getValue()) {
                AdapterInstanceContextInfo connector = new AdapterInstanceContextInfo();
                connector.setAdapterType("IDP_ADAPTER");
                connector.setAdapterInstanceUsageContext("USED_IN_CONNECTION");
                connector.setAdapterId(instance.getId());
                IdpAuthnAdapterDescriptor desc = instance.getDescriptor();
                String className = desc.getAdapterClassName();
                connector.setAdapterClassName(className);
                this.setOpenIdValues(instance, connector);
                connector.setPartnerSpId(spConn.getEntityId());
                connector.setConnectionName(spConn.getName());
                connector.setIdpInitSSO(spConn.getEnabledProfiles().isIdpInitiatedSSOEnabled());
                connector.setSpInitSSO(spConn.getEnabledProfiles().isSpInitiatedSSOEnabled());
                connector.setActive(spConn.isActive());
                connectors.add(connector);
            }
        }
        return connectors;
    }

    List<AdapterInstanceContextInfo> buildCloudConnectorListFromA2A(Map<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>> idpAdaptersToA2AMappings) {
        ArrayList<AdapterInstanceContextInfo> connectors = new ArrayList<AdapterInstanceContextInfo>();
        for (Map.Entry<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>> e : idpAdaptersToA2AMappings.entrySet()) {
            IdpAuthnAdapterInstance instance = e.getKey();
            for (Source2TargetMapping source2TargetMapping : e.getValue()) {
                AdapterInstanceContextInfo connector = new AdapterInstanceContextInfo();
                connector.setAdapterType("IDP_ADAPTER");
                connector.setAdapterInstanceUsageContext("USED_IN_ADAPTER_2_ADAPTER");
                connector.setAdapterId(instance.getId());
                IdpAuthnAdapterDescriptor desc = instance.getDescriptor();
                connector.setAdapterClassName(desc.getAdapterClassName());
                connector.setSpSessionAuthnAdapterId(source2TargetMapping.getTargetId());
                this.setOpenIdValues(instance, connector);
                connectors.add(connector);
            }
        }
        return connectors;
    }

    private void setOpenIdValues(IdpAuthnAdapterInstance instance, ExtAdapterInstanceContextInfo adapterInstanceContextInfo) {
        Configuration config = instance.getConfiguration();
        Field providerField = config.getField(PROVIDER_FIELD);
        if (providerField != null) {
            adapterInstanceContextInfo.setProvider(providerField.getValue());
            Field domainNameField = config.getField(DOMAIN_FIELD);
            if (domainNameField != null) {
                adapterInstanceContextInfo.setDomain(domainNameField.getValue());
            }
        }
    }

    private void setOpenIdValues(IdpAuthnAdapterInstance instance, AdapterInstanceContextInfo adapterInstanceContextInfo) {
        Configuration config = instance.getConfiguration();
        Field providerField = config.getField(PROVIDER_FIELD);
        if (providerField != null) {
            adapterInstanceContextInfo.setProvider(providerField.getValue());
            Field domainNameField = config.getField(DOMAIN_FIELD);
            if (domainNameField != null) {
                adapterInstanceContextInfo.setDomain(domainNameField.getValue());
            }
        }
    }
}

