/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.ws;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.saml20.domain.AppAuthMap;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl;
import org.sourceid.servlet.filter.AbstractHttpFilter;

public class WsAuthnFilter
extends AbstractHttpFilter {
    private static final Log log = LogFactory.getLog(WsAuthnFilter.class);
    private final LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(this.getClass().getName());
    private final AppAuthMapManagerImpl appAuthMgr = new AppAuthMapManagerImpl();

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean isSsoDirectoryService = request.getRequestURI().contains("SSODirectoryService");
        AppAuthMap appAuthMap = isSsoDirectoryService ? this.appAuthMgr.getSsoDirectoryServiceMap() : this.appAuthMgr.getConnectionManagementMap();
        if (appAuthMap.isActive()) {
            String authnHeaderValue = BasicAuthHelp.getAuthTokenFromHeaders(request);
            boolean executeService = false;
            if (isSsoDirectoryService && (appAuthMap.getId() == null || appAuthMap.getId().isEmpty())) {
                executeService = true;
            } else if (authnHeaderValue != null) {
                try {
                    BasicAuthValue values = BasicAuthHelp.getValues(authnHeaderValue);
                    String userKey = AccountLockingService.getUserKey(request.getRemoteAddr(), values.getUsername());
                    if (this.accountLockingService.isLocked(userKey)) {
                        this.sendAccountLockedResponse(request, response);
                        return;
                    }
                    executeService = appAuthMap.authenticate(values.getUsername(), values.getPassword());
                    if (!executeService) {
                        this.accountLockingService.logFailedLogin(userKey);
                        if (this.accountLockingService.isLocked(userKey)) {
                            this.sendAccountLockedResponse(request, response);
                            return;
                        }
                        throw new LoginException();
                    }
                    this.accountLockingService.clearFailedLogins(userKey);
                }
                catch (LoginException e) {
                    executeService = false;
                    log.info((Object)("Web Service Attempted: service=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false, service-active=true, msg=" + e.getMessage()));
                }
            }
            if (executeService) {
                log.info((Object)("Web Service Attempted: service=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=true, service-active=true"));
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                BasicAuthHelp.sendChallenge(response);
            }
        } else {
            log.info((Object)("Web Service Attempted: service=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false, service-active=false"));
        }
    }

    private void sendAccountLockedResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info((Object)("Web Service Attempted: service=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false, service-active=true, msg=Account Locked"));
        BasicAuthHelp.sendChallenge(response, "Too many failed logins, your account is temporarily locked.");
    }
}

