/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.a2a;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.Adapter2AdapterMappingIdpAdapterSupport;
import org.sourceid.a2a.Adapter2AdapterMappingSpAdapterSupport;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.ErrorCodeException;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.profiles.sp.SLOSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupportBase;
import org.sourceid.saml20.profiles.sp.TargetUrlMappingUtil;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.PseudonymServiceException;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.servlet.QuietException;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestCreatorBase;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLoggerSupport;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class Adapter2AdapterMappingReqCreator
extends ResumableRequestCreatorBase
implements ResumeRequestFromAuthnResponseHandler {
    private static final AuthnPolicy AUTHN_POLICY = new AuthnPolicy(true, false);
    private static final String SSO_CTX_KEY = "ctx";
    private final Adapter2AdapterMappingIdpAdapterSupport idpAdapterSupport = new Adapter2AdapterMappingIdpAdapterSupport();
    private final Adapter2AdapterMappingSpAdapterSupport spAdapterSupport = new Adapter2AdapterMappingSpAdapterSupport();
    private final MetadataLocal localMetaData;
    private final org.sourceid.websso.profiles.idp.SsoRespSupport idpRespSupport;
    private final SsoRespSupport spRespSupport;
    private final TargetUrlMappingUtil urlAdapterUtil;
    private final Adapter2AdapterManager adapter2AdapterManager = MgmtFactory.getAdapter2AdapterManager();
    private final SLOSupport sloSupport = new SLOSupport();

    public Adapter2AdapterMappingReqCreator(MetadataLocal localMetaData) {
        this.localMetaData = localMetaData;
        this.idpRespSupport = new org.sourceid.websso.profiles.idp.SsoRespSupport();
        this.spRespSupport = new SsoRespSupport(localMetaData);
        this.urlAdapterUtil = new TargetUrlMappingUtil();
    }

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.checkIfA2ADisabled(resp)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String spAdapterId = ProprietaryURLParams.getParam(req, "SpSessionAuthnAdapterId");
        params.put("SpSessionAuthnAdapterId", spAdapterId);
        String targetResource = ProprietaryURLParams.getParam(req, "TargetResource");
        params.put("TARGET", targetResource);
        String errorResource = ProprietaryURLParams.getParam(req, "InErrorResource");
        params.put("InErrorResource", errorResource);
        this.addTrackedParams(req, params);
        String policyAction = ProprietaryURLParams.getParam(req, "PolicyAction");
        params.put("PolicyAction", policyAction);
        return this.resume(null, req, resp, params);
    }

    public static boolean isAdapter2AdapterDisabled() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        AuthnSelectionConfigManager policyMgr = MgmtFactory.getAuthnSelectionConfigManager();
        boolean isIdpAuthnPolicyEnabled = policyMgr.isEnableIdpAuthnSelection() && MetadataLocalHelper.isEnableIdp(localMetaData);
        boolean isSpAuthnPolicyEnabled = policyMgr.isEnableSpAuthnSelection() && MetadataLocalHelper.isEnableSp(localMetaData);
        return !isIdpAuthnPolicyEnabled && isSpAuthnPolicyEnabled;
    }

    private boolean checkIfA2ADisabled(HttpServletResponse resp) throws IOException {
        boolean disableA2A = Adapter2AdapterMappingReqCreator.isAdapter2AdapterDisabled();
        if (disableA2A) {
            this.log.info((Object)"/pf/adapter2adapter.ping endpoint disabled to prevent authn policy circumvention. Endpoint is only enabled when IdP and SP authn polices are both enabled or both disabled.");
            resp.sendError(404);
        }
        return disableA2A;
    }

    @Override
    protected OutMessageContext doResume(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException {
        if (this.checkIfA2ADisabled(resp)) {
            return null;
        }
        try {
            IdpAuditLogger.setEvent("SSO");
            this.myResume(req, resp, params);
        }
        catch (Exception e) {
            IdpAuditLogger.setStatus("failure");
            IdpAuditLogger.setDescription(e.getMessage());
            IdpAuditLogger.log(e.getMessage());
            if (!(e.getCause() instanceof QuietException)) {
                this.logEx(e);
            }
            String errorResource = (String)params.get("InErrorResource");
            String adapterId = AuthnPolicyUtil.getDefault().getNonConnBasedAdapterId(req, params);
            adapterId = adapterId == null ? "Unknown" : adapterId;
            this.idpRespSupport.handleException(e, req, resp, params, errorResource, adapterId, null, null, Role.IDP);
        }
        return null;
    }

    private void logEx(Exception e) {
        if (!(e instanceof QuietException)) {
            this.log.error((Object)"Unexpected error.", (Throwable)e);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)e.getMessage());
        }
    }

    private void myResume(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException, AuthnFailedException {
        SsoContext ssoContext = (SsoContext)params.get(SSO_CTX_KEY);
        if (ssoContext == null) {
            IdpAuthenticationResult authnResult;
            AuthnSourceKey sourceKey = (AuthnSourceKey)params.get("mappedAuthnSource");
            String pfidpadapterid = null;
            if (sourceKey == null) {
                sourceKey = this.idpAdapterSupport.fromCookieValue(req.getParameter("pfidpadapterid"));
            }
            if (sourceKey != null) {
                pfidpadapterid = sourceKey.getId();
            }
            String targetUrl = this.getTargetUrl(pfidpadapterid, params);
            String spAdapterId = this.getSpAdapterId(params, targetUrl);
            String idpAdapterId = ProprietaryURLParams.getParam(req, "IdpAdapterId");
            boolean licenseChecked = false;
            if (!StringUtils.isEmpty((String)idpAdapterId)) {
                this.checkLicense(idpAdapterId, spAdapterId);
                licenseChecked = true;
            }
            String resumePath = this.saveState(req, resp, null, params);
            try {
                authnResult = this.idpAdapterSupport.lookupAuthNs(req, resp, AUTHN_POLICY, resumePath, params, null, null, this, false);
            }
            catch (AuthorizationException | AuthnProcessorException e) {
                throw new GeneralAdapterException(e.getMessage(), (Throwable)e);
            }
            if (!licenseChecked && authnResult != null && !Util.isEmpty(authnResult.getAuthnAttrs())) {
                idpAdapterId = authnResult.getLastAuthnSourceKey().getId();
                this.checkLicense(idpAdapterId, spAdapterId);
            }
            if (resp.isCommitted()) {
                return;
            }
            this.checkAuthn(authnResult);
            this.addContextSpecificAttributes(params, authnResult.getAuthnAttrs());
            IdpAuditLoggerSupport.getInstance().constructAuditId(authnResult);
            AttributeMap mappedAttributes = this.mapAttributes(req, resp, authnResult, spAdapterId, params);
            IdpAuditLogger.setAttributes(mappedAttributes.toString());
            if (StringUtils.isBlank((String)targetUrl)) {
                targetUrl = this.getTargetUrl(idpAdapterId, params);
            }
            if (StringUtils.isBlank((String)targetUrl)) {
                this.log.warn((Object)"Unable to determine Target URL. TargetResource needs to be defined as a query parameter or a default Target URL needs to be configured");
                throw new NoTargetUrlException();
            }
            ssoContext = this.createSsoCtx(targetUrl, authnResult, mappedAttributes);
            params.put(SSO_CTX_KEY, ssoContext);
        }
        String resumePath = this.saveState(req, resp, null, params);
        String spAdapterId = (String)params.get("SpSessionAuthnAdapterId");
        TargetSessionId targetSessionId = new TargetSessionId(TargetSessionId.TargetSessionType.ADAPTER, spAdapterId);
        SpHashableAuthnBean authnBean = this.spAdapterSupport.createAuthN(ssoContext, req, resp, targetSessionId, resumePath, null, null, null);
        if (SpAdapterSupportBase.isCreateAuthnComplete(req, resp)) {
            if (this.sloSupport.checkRegisterSpAuthnBean(null, targetSessionId)) {
                SpSessionRegistrySupport.registerAuthnBean(authnBean);
            }
            this.spRespSupport.finishAndRedirect(req, resp, ssoContext, false);
        }
    }

    private void addContextSpecificAttributes(Map<String, Object> params, AttributeMap sourceAttrs) {
        if (params.get("TARGET") != null) {
            sourceAttrs.put("TargetResource", new AttributeValue((String)params.get("TARGET")));
        }
    }

    private void checkLicense(String idpAdapterId, String spAdapterId) {
        Object mapping = this.adapter2AdapterManager.getMapping(idpAdapterId, spAdapterId);
        LicenseManager.checkLicenseForConnection(mapping);
    }

    private SsoContext createSsoCtx(String targetUrl, IdpAuthenticationResult authnResult, AttributeMap mappedAttrs) {
        AuthnSourceKey authnSourceKey = authnResult.getLastAuthnSourceKey();
        String idpAdapterId = authnSourceKey.getId();
        AttributeValue authnCtxValue = this.idpRespSupport.getAuthnCtxFromAuthnAttrs(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), null);
        String authnCtx = authnCtxValue == null ? null : authnCtxValue.getValue();
        Calendar instantCal = this.idpRespSupport.getAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans());
        Date authnInstant = instantCal.getTime();
        return new SsoContext(mappedAttrs, null, null, idpAdapterId, targetUrl, authnCtx, authnInstant);
    }

    private String getSpAdapterId(Map<String, Object> params, String targetUrl) {
        TargetSessionId mappedTargetSessionId;
        List<TargetSessionId> targetSessionIds;
        String spAdapterId = (String)params.get("SpSessionAuthnAdapterId");
        if (StringUtils.isBlank((String)spAdapterId) && !(targetSessionIds = this.urlAdapterUtil.mapToTargetIds(targetUrl)).isEmpty() && (mappedTargetSessionId = targetSessionIds.get(0)).getType() == TargetSessionId.TargetSessionType.ADAPTER) {
            spAdapterId = mappedTargetSessionId.getId();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No SpSessionAuthnAdapterId specified so mapped from " + targetUrl + " to " + spAdapterId));
            }
        }
        if (spAdapterId == null) {
            throw new ProcessRuntimeException("Unable to determine SP Adapter - please specify a SpSessionAuthnAdapterId parameter or ensure that the given TargetResource parameter (or default) maps to a SP Adapter Instance ID");
        }
        params.put("SpSessionAuthnAdapterId", spAdapterId);
        return spAdapterId;
    }

    private String getTargetUrl(String pfidpadapterid, Map<String, Object> params) {
        String spAdapterId;
        String targetUrl = (String)params.get("TARGET");
        if (StringUtils.isBlank((String)targetUrl) && StringUtils.isBlank((String)(targetUrl = this.adapter2AdapterManager.getTargetUrl(pfidpadapterid, spAdapterId = (String)params.get("SpSessionAuthnAdapterId")))) && (targetUrl = this.localMetaData.getApplicationURL("sp.after.sso")) != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("No TargetResource parameter specified so using default: " + targetUrl));
        }
        return targetUrl;
    }

    private void checkAuthn(IdpAuthenticationResult authnResult) throws AuthnFailedException {
        if (authnResult == null) {
            throw new AuthnFailedException();
        }
    }

    private AttributeMap mapAttributes(HttpServletRequest req, HttpServletResponse resp, IdpAuthenticationResult authnResult, String spAdapterId, Map<String, Object> params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Executing mapping from IdP adapter '" + authnResult.getLastAuthnSourceKey().getId() + "' to SP adapter '" + spAdapterId + "'"));
        }
        AuthnSourceKey authnSourceKey = authnResult.getLastAuthnSourceKey();
        String idpAdapterId = authnSourceKey.getId();
        Object mapper = this.adapter2AdapterManager.getMapping(idpAdapterId, spAdapterId);
        AttributeMap contextAttributes = new AttributeMap();
        contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
        contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        contextAttributes.put(SourceContextType.SRI.getId(), SessionIdUtil.getInstance().getExtendedSriV2(req, resp, params));
        AttributeValue authnCtxValue = this.idpRespSupport.getAuthnCtxFromAuthnAttrs(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), null);
        if (authnCtxValue != null) {
            contextAttributes.put(SourceContextType.AUTHN_CTX.getId(), authnCtxValue);
        }
        try {
            return ((AttributeMapping)mapper).executeMapping(authnResult.getAuthnAttrs(), null, contextAttributes);
        }
        catch (AuthorizationException e) {
            throw new ProcessRuntimeException(e.getMessage(), e);
        }
        catch (AttrLookupException e) {
            throw new ProcessRuntimeException("Error occurred in attribute mapping / lookup: " + e.getMessage(), e);
        }
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    @Override
    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException {
        try {
            this.doResume(outMsgCtx, req, resp, otherState);
        }
        catch (GeneralAdapterException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext respOutMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) throws PseudonymServiceException, RequestProcessingException {
        throw new UnsupportedOperationException();
    }

    private class NoTargetUrlException
    extends GeneralAdapterException
    implements QuietException {
        private static final long serialVersionUID = 1L;

        public NoTargetUrlException() {
            super("Unable to determine Target URL.");
        }
    }

    private class AuthnFailedException
    extends Exception
    implements QuietException,
    ErrorCodeException {
        private static final long serialVersionUID = 1L;

        private AuthnFailedException() {
        }

        @Override
        public String getMessage() {
            return "Authentication Failed";
        }

        @Override
        public String getErrorCode() {
            return "AUTHENTICATION_FAILED";
        }

        @Override
        public String getErrorDetail() {
            return "errorDetail.authenticationFailed";
        }

        @Override
        public String[] getErrorDetailParameters() {
            return null;
        }
    }
}

