/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.a2a;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.a2a.domain.mgmt.Apc2SpAdapterManager;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.TargetAttributeMappingDb;
import org.sourceid.saml20.metadata.partner.TargetAttributeMappingDbEntry;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.authn.MappedAuthnSourcesAndApcs;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.BaseMessageContext;

public class Apc2SpaMappingAuthnSupport
extends AuthnSourceSupportBase {
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private final TargetAttributeMappingDb targetAttributeMappingDb = MgmtFactory.getTargetAttributeMappingDb();
    private final Apc2SpAdapterManager apc2SpAdapterManager = MgmtFactory.getApc2SpAdapterManager();
    private final Adapter2AdapterManager adapter2AdapterManager = MgmtFactory.getAdapter2AdapterManager();

    @Override
    protected MappedAuthnSourcesAndApcs getMappedSources(HttpServletRequest req, Map<String, Object> stateParams, BaseMessageContext messageContext, ProxyScoping proxyScoping) {
        String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
        String virtualServerId = (String)stateParams.get("chainedVsid");
        HashSet<AuthnSourceKey> authnSourceKeys = new HashSet<AuthnSourceKey>();
        HashSet<String> apcIds = new HashSet<String>();
        if (MetadataLocalHelper.isEnableIdp(this.localMetaData)) {
            for (Direct2SpAdapterMapping a2aMapping : this.adapter2AdapterManager.getMappingsUsingTarget(spAdapterId)) {
                if (this.adapterManager.getIdpAuthnAdapterInstance(a2aMapping.getSourceId()) == null) continue;
                authnSourceKeys.add(new AdapterAuthnSourceKey(a2aMapping.getSourceId()));
            }
        }
        for (Object apc2AdapterMapping : this.apc2SpAdapterManager.getMappingsUsingTarget(spAdapterId)) {
            apcIds.add(((Source2TargetMapping)apc2AdapterMapping).getSourceId());
        }
        if (MetadataLocalHelper.isEnableSp(this.localMetaData)) {
            Collection<TargetAttributeMappingDbEntry> entries = this.targetAttributeMappingDb.getEntriesByAdapterId(spAdapterId);
            block2: for (TargetAttributeMappingDbEntry entry : entries) {
                IdpConnection idpConn = this.metadataDirectory.getIdpConnectionBySystemId(entry.getSystemId(), false);
                if (!idpConn.isActive() || !this.connectionManager.passesFilterByServerSettings(idpConn, false)) continue;
                AuthnAdapterInstance spInstance = this.adapterManager.getSpAuthnAdapterInstanceWithConnectionOverride(spAdapterId, idpConn.getEntityId());
                String overriddenSpAdapterId = null;
                if (spInstance != null) {
                    overriddenSpAdapterId = spInstance.getId();
                }
                for (TargetAttributeMapping mapping : idpConn.getTargetAttributeMappings()) {
                    if ((overriddenSpAdapterId != null || !mapping.getAdapterInstanceId().equals(spAdapterId)) && !mapping.getAdapterInstanceId().equals(overriddenSpAdapterId) || mapping.isRestrictVirtualServerIds() && virtualServerId != null && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
                    authnSourceKeys.add(new IdpConnAuthnSourceKey(idpConn.getId()));
                    continue block2;
                }
            }
            AuthnAdapterInstance spInstance = this.adapterManager.getSpAuthnAdapterInstance(spAdapterId);
            if (spInstance != null && !Util.isEmpty(spInstance.getAllowedApcs())) {
                apcIds.addAll(spInstance.getAllowedApcs());
            }
        }
        if (authnSourceKeys.isEmpty() && apcIds.isEmpty()) {
            throw new ProcessRuntimeException("No applicable mappings are configured that map into the given SP Adapter Instance: " + spAdapterId);
        }
        return new MappedAuthnSourcesAndApcs(authnSourceKeys, apcIds);
    }

    @Override
    protected String makeNoMappingErrMsg(Map<String, Object> stateParams, String escapedParam) {
        String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
        StringBuilder sb = new StringBuilder();
        sb.append("IdpAdapterId").append(" was specified as ").append(escapedParam);
        sb.append(" but no adapter-to-adapter mapping exists from that IdP Adapter to the given SP Adapter: ");
        sb.append(spAdapterId);
        return sb.toString();
    }

    @Override
    protected void addApplicationNameImage(Map<String, Object> stateParams, AuthnSourceKey authnSourceKey) {
        String spAdapterApplicationIconUrl;
        String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
        String spAdapterApplicationName = this.getSpAdapterApplicationName(spAdapterId);
        if (StringUtils.isNotBlank((String)spAdapterApplicationName)) {
            stateParams.put("applicationName", spAdapterApplicationName);
        }
        if (StringUtils.isNotBlank((String)(spAdapterApplicationIconUrl = this.getSpAdapterApplicationIconUrl(spAdapterId)))) {
            stateParams.put("applicationIcon", spAdapterApplicationIconUrl);
        }
    }

    @Override
    protected boolean isAuthnSelectionEnabled(Map<String, Object> stateParams) {
        if (this.authnSelectorConfigManager.isEnableSpAuthnSelection()) {
            return true;
        }
        String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
        if (spAdapterId == null) {
            return false;
        }
        AuthnAdapterInstance spInstance = this.adapterManager.getSpAuthnAdapterInstance(spAdapterId);
        return spInstance != null && spInstance.isVirtualInstance();
    }
}

