/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.a2a.domain.mgmt;

import com.pingidentity.common.util.SerialHashable;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.mgmt.Source2TargetManager;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;
import org.sourceid.source2target.xmlbinding.MappingsType;
import org.sourceid.source2target.xmlbinding.Source2TargetPluginMappingType;
import org.sourceid.source2target.xmlbinding.Source2TargetPluginMappingsDocument;

public abstract class Source2TargetManagerImpl<T extends Source2TargetMapping>
implements Source2TargetManager<T>,
AutoReloadable {
    private Map<SerialHashable, T> mappings;
    private XmlLoader xmlLoader;
    private String directory;

    public Source2TargetManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo, Mediator mediator) {
        this(xmlLoader, sysDirInfo.getDataDirectory());
    }

    Source2TargetManagerImpl(XmlLoader xmlLoader, String dir) {
        this.xmlLoader = xmlLoader;
        this.directory = dir;
        this.loadConfig();
    }

    @Override
    public synchronized Collection<T> getMappings() {
        return Collections.unmodifiableCollection(this.mappings.values());
    }

    @Override
    public synchronized void saveMappings(Collection<T> a2aMappings) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.save(a2aMappings);
            auditLoggerScope.log(this.getAdminAuditLoggerComponent(), AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void saveMapping(T a2aMapping) {
        SerialHashable key = this.makeHashKey(((Source2TargetMapping)a2aMapping).getSourceId(), ((Source2TargetMapping)a2aMapping).getTargetId());
        Source2TargetMapping existingValue = (Source2TargetMapping)this.mappings.put(key, a2aMapping);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.save(this.mappings.values());
            auditLoggerScope.log(this.getAdminAuditLoggerComponent(), existingValue != null ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getMapping(String idpAdapterId, String spAdapterId) {
        Source2TargetMapping a2aMapping;
        SerialHashable key = this.makeHashKey(idpAdapterId, spAdapterId);
        Source2TargetManagerImpl source2TargetManagerImpl = this;
        synchronized (source2TargetManagerImpl) {
            a2aMapping = (Source2TargetMapping)this.mappings.get(key);
        }
        return (T)a2aMapping;
    }

    @Override
    public synchronized void deleteMapping(T a2aMapping) {
        SerialHashable key = this.makeHashKey(((Source2TargetMapping)a2aMapping).getSourceId(), ((Source2TargetMapping)a2aMapping).getTargetId());
        Source2TargetMapping removedMapping = (Source2TargetMapping)this.mappings.remove(key);
        if (removedMapping != null) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                this.save(this.mappings.values());
                auditLoggerScope.log(this.getAdminAuditLoggerComponent(), AdminAuditLogger.Event.DELETE);
            }
        }
    }

    private SerialHashable makeHashKey(String idpAdapterId, String spAdapterId) {
        return SerialHashable.newInstance(new Serializable[]{idpAdapterId, spAdapterId});
    }

    @Override
    public synchronized boolean isSourceInUse(String id) {
        for (Source2TargetMapping source2TargetMapping : this.mappings.values()) {
            if (!StringUtils.equals((String)id, (String)source2TargetMapping.getSourceId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isTargetInUse(String id) {
        for (Source2TargetMapping source2TargetMapping : this.mappings.values()) {
            if (!StringUtils.equals((String)id, (String)source2TargetMapping.getTargetId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<T> getMappingsMappedToSource(String sourceId) {
        ArrayList<Source2TargetMapping> targetsMappedToSourceId = new ArrayList<Source2TargetMapping>();
        for (Source2TargetMapping source2TargetMapping : this.mappings.values()) {
            if (!StringUtils.equals((String)sourceId, (String)source2TargetMapping.getSourceId())) continue;
            targetsMappedToSourceId.add(source2TargetMapping);
        }
        return targetsMappedToSourceId;
    }

    private synchronized void save(Collection<T> source2TargetMappings) {
        ConnectionUtil connUtil = new ConnectionUtil();
        Source2TargetPluginMappingsDocument doc = Source2TargetPluginMappingsDocument.Factory.newInstance();
        MappingsType mappingsType = doc.addNewSource2TargetPluginMappings();
        for (Source2TargetMapping mapping : source2TargetMappings) {
            String licenseGroup;
            Source2TargetPluginMappingType source2TargetMappingType = mappingsType.addNewSource2TargetPluginMapping();
            source2TargetMappingType.setSourcePluginId(mapping.getSourceId());
            source2TargetMappingType.setTargetPluginId(mapping.getTargetId());
            source2TargetMappingType.setCountForLicense(mapping.isCountForLicense());
            if (StringUtils.isNotBlank((String)mapping.getDefaultTargetResource())) {
                source2TargetMappingType.setDefaultTargetResource(mapping.getDefaultTargetResource());
            }
            if ((licenseGroup = mapping.getLicenseConnectionGroupAssignment()) != null) {
                source2TargetMappingType.setLicenseGroup(licenseGroup);
            }
            this.saveAdditionalAttributesToXml(mapping, source2TargetMappingType);
            connUtil.fillInAttributeMappingType(source2TargetMappingType.addNewAttributeMapping(), mapping);
        }
        this.xmlLoader.save(this.directory, this.getConfigFileName(), (XmlObject)doc);
        this.loadConfig();
        MetaDataFactory.getLocalMetaData().reload();
    }

    private synchronized Map<SerialHashable, T> loadFromXml() {
        HashMap<SerialHashable, T> map = new HashMap<SerialHashable, T>();
        if (this.xmlLoader.xmlExists(this.directory, this.getConfigFileName())) {
            Source2TargetPluginMappingsDocument doc = (Source2TargetPluginMappingsDocument)this.xmlLoader.load(this.directory, this.getConfigFileName());
            MappingsType adapter2AdapterMappings = doc.getSource2TargetPluginMappings();
            ConnectionUtil connUtil = new ConnectionUtil();
            for (Source2TargetPluginMappingType s2tMappingType : adapter2AdapterMappings.getSource2TargetPluginMappingArray()) {
                T source2TargetMapping = this.makeMapping();
                String idpId = s2tMappingType.getSourcePluginId();
                ((Source2TargetMapping)source2TargetMapping).setSourceId(idpId);
                String spId = s2tMappingType.getTargetPluginId();
                ((Source2TargetMapping)source2TargetMapping).setTargetId(spId);
                AttributeMappingType mappingType = s2tMappingType.getAttributeMapping();
                connUtil.fillAttrMappingFromXml(mappingType, (AttributeMapping)source2TargetMapping);
                boolean countForLicense = false;
                if (s2tMappingType.isSetCountForLicense()) {
                    countForLicense = s2tMappingType.getCountForLicense();
                }
                ((Source2TargetMapping)source2TargetMapping).setCountForLicense(countForLicense);
                if (s2tMappingType.isSetLicenseGroup()) {
                    ((Source2TargetMapping)source2TargetMapping).setLicenseConnectionGroupAssignment(s2tMappingType.getLicenseGroup());
                }
                if (s2tMappingType.isSetDefaultTargetResource()) {
                    ((Source2TargetMapping)source2TargetMapping).setDefaultTargetResource(s2tMappingType.getDefaultTargetResource());
                }
                this.loadAdditionalAttributesFromXml((Source2TargetMapping)source2TargetMapping, s2tMappingType);
                SerialHashable key = this.makeHashKey(idpId, spId);
                map.put(key, source2TargetMapping);
            }
        }
        return map;
    }

    private synchronized void loadConfig() {
        this.mappings = this.loadFromXml();
    }

    @Override
    public boolean isDataSourceInUse(String id) {
        boolean inUse = false;
        Iterator<T> iter = this.mappings.values().iterator();
        block0: while (iter.hasNext() && !inUse) {
            Source2TargetMapping source2TargetMapping = (Source2TargetMapping)iter.next();
            for (AttributeSource attributeSource : source2TargetMapping.getAttributeSources()) {
                if (attributeSource.getDataSource() == null || !attributeSource.getDataSource().getId().equals(id)) continue;
                inUse = true;
                continue block0;
            }
        }
        return inUse;
    }

    @Override
    public synchronized List<T> getMappingsUsingDataSource(String id) {
        LinkedList<Source2TargetMapping> mappingsInUse = new LinkedList<Source2TargetMapping>();
        block0: for (Source2TargetMapping source2TargetMapping : this.mappings.values()) {
            for (AttributeSource attributeSource : source2TargetMapping.getAttributeSources()) {
                if (attributeSource.getDataSource() == null || !attributeSource.getDataSource().getId().equals(id)) continue;
                mappingsInUse.add(source2TargetMapping);
                continue block0;
            }
        }
        return mappingsInUse;
    }

    @Override
    public synchronized List<T> getMappingsUsingSource(String id) {
        LinkedList<Source2TargetMapping> mappingsInUse = new LinkedList<Source2TargetMapping>();
        for (Source2TargetMapping source2TargetMapping : this.mappings.values()) {
            if (!id.equals(source2TargetMapping.getSourceId())) continue;
            mappingsInUse.add(source2TargetMapping);
        }
        return mappingsInUse;
    }

    @Override
    public synchronized List<T> getMappingsUsingTarget(String id) {
        LinkedList<Source2TargetMapping> mappingsInUse = new LinkedList<Source2TargetMapping>();
        for (Source2TargetMapping source2TargetMapping : this.mappings.values()) {
            if (!id.equals(source2TargetMapping.getTargetId())) continue;
            mappingsInUse.add(source2TargetMapping);
        }
        return mappingsInUse;
    }

    @Override
    public int getMappingCount() {
        int count = 0;
        if (this.mappings.size() > 0) {
            for (Source2TargetMapping source2TargetMapping : this.mappings.values()) {
                if (!source2TargetMapping.isCountForLicense()) continue;
                ++count;
            }
        }
        return count;
    }

    protected abstract String getConfigFileName();

    protected abstract T makeMapping();

    protected void loadAdditionalAttributesFromXml(Source2TargetMapping source2TargetMapping, Source2TargetPluginMappingType s2tMappingType) {
    }

    protected void saveAdditionalAttributesToXml(Source2TargetMapping mapping, Source2TargetPluginMappingType source2TargetMappingType) {
    }

    protected abstract AdminAuditLogger.Component getAdminAuditLoggerComponent();
}

