/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class BasicAuth {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String AUTH_HEADER = "Authorization";
    public static final String WWW_AUTHN = "WWW-Authenticate";
    private static final LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(BasicAuth.class.getName());
    private final SoapAuthStore soapAuthStore;

    public BasicAuth(SoapAuthStore soapAuthStore) {
        this.soapAuthStore = soapAuthStore;
    }

    public String doBasicAuth(HttpServletRequest req) throws LoginException {
        String authHeader = BasicAuthHelp.getAuthTokenFromHeaders(req);
        if (authHeader != null) {
            return this.doAuthn(req.getRemoteAddr(), authHeader);
        }
        return null;
    }

    String doAuthn(String remoteIp, String authHeader) throws LoginException {
        BasicAuthValue values = BasicAuthHelp.getValues(authHeader);
        String username = values.getUsername();
        String password = values.getPassword();
        return this.doBasicAuthn(remoteIp, username, password);
    }

    protected String doBasicAuthn(String remoteIp, String username, String password) throws LoginException {
        String userKey = AccountLockingService.getUserKey(remoteIp, username);
        if (accountLockingService.isLocked(userKey)) {
            throw new LoginException("Too many failed logins, account temporarily locked");
        }
        SoapAuthInfo incoming = this.soapAuthStore.getByIncomingBasic(username);
        String providerID = null;
        if (incoming != null && incoming.isHasBasicEntry()) {
            SoapAuthInfo.IncomingBasicAuthInfo basicInfo = (SoapAuthInfo.IncomingBasicAuthInfo)incoming.getBasicAuthInfo();
            if (basicInfo.checkSecret(password)) {
                providerID = incoming.getEntityId();
                accountLockingService.clearFailedLogins(userKey);
            } else {
                accountLockingService.logFailedLogin(userKey);
                this.log.warn((Object)("Bad password for " + username));
            }
        } else {
            accountLockingService.logFailedLogin(userKey);
            this.log.warn((Object)("Wrong credential for " + username));
        }
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Password Authn ").append(username).append(" -> ").append(providerID);
            this.log.debug((Object)sb);
        }
        if (providerID == null) {
            if (accountLockingService.isLocked(userKey)) {
                throw new LoginException("Too many failed logins, account temporarily locked");
            }
            throw new LoginException("Basic auth failed for " + username);
        }
        return providerID;
    }
}

