/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth.radius;

import com.pingidentity.configservice.Reloadable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.tinyradius.attribute.IntegerAttribute;
import org.tinyradius.attribute.IpAttribute;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.StringAttribute;
import org.tinyradius.attribute.VendorSpecificAttribute;
import org.tinyradius.dictionary.AttributeType;
import org.tinyradius.dictionary.MemoryDictionary;

public class FreeRadiusDictionary
extends MemoryDictionary
implements Reloadable {
    private static final String SEPARATOR_REGEX = "[\t ]+";
    private static final String COMMENT = "#";
    private static final String INCLUDE = "$INCLUDE";
    private static final String BEGIN_VENDOR = "BEGIN-VENDOR";
    private static final String END_VENDOR = "END-VENDOR";
    private static final String ATTRIBUTE = "ATTRIBUTE";
    private static final String VALUE = "VALUE";
    private static final String VENDOR = "VENDOR";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_OCTETS = "octets";
    private static final String TYPE_INTEGER = "integer";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_IPADDR = "ipaddr";
    private static final String DICTIONARY_NAME = "dictionary";
    private static final String SERVER_DEFAULT_DIR = System.getProperty("pf.server.default.dir", "");
    private static final Path CONF_DIRECTORY = FileSystems.getDefault().getPath(SERVER_DEFAULT_DIR, "conf", "radius");
    private static volatile FreeRadiusDictionary instance = new FreeRadiusDictionary();
    private String currentVendor = null;

    private FreeRadiusDictionary() {
        this.parseDictionary(DICTIONARY_NAME);
        MgmtFactory.getMediator().registerForReloadEvents(this);
    }

    public static FreeRadiusDictionary getInstance() {
        return instance;
    }

    @Override
    public void reload() {
        if (instance != null) {
            MgmtFactory.getMediator().unregisterForReloadEvents(instance);
        }
        FreeRadiusDictionary.createInstance();
    }

    private static void createInstance() {
        instance = new FreeRadiusDictionary();
    }

    private void parseDictionary(String dictionaryName) {
        Path dictionaryPath = CONF_DIRECTORY.resolve(dictionaryName);
        if (Files.isRegularFile(dictionaryPath, new LinkOption[0])) {
            try {
                int lineNumber = 1;
                for (String line : Files.readAllLines(dictionaryPath, Charset.forName("UTF-8"))) {
                    if ((line = line.trim()).startsWith(COMMENT) || StringUtils.isBlank((String)line)) continue;
                    String upperLine = line.toUpperCase();
                    if (upperLine.startsWith(INCLUDE)) {
                        this.parseInclude(line, lineNumber);
                    } else if (upperLine.startsWith(BEGIN_VENDOR)) {
                        this.parseBeginVendor(line, lineNumber);
                    } else if (upperLine.startsWith(END_VENDOR)) {
                        this.parseEndVendor(line, lineNumber);
                    } else if (upperLine.startsWith(ATTRIBUTE)) {
                        this.parseAttribute(line, lineNumber);
                    } else if (upperLine.startsWith(VALUE)) {
                        this.parseValue(line, lineNumber);
                    } else if (upperLine.startsWith(VENDOR)) {
                        this.parseVendor(line, lineNumber);
                    }
                    ++lineNumber;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to parse dictionary " + dictionaryPath.getFileName(), e);
            }
        }
    }

    private void parseInclude(String line, int lineNumber) {
        List<String> parts = this.parseLine(line);
        if (parts.size() != 2) {
            throw new RuntimeException("Syntax error on line " + lineNumber);
        }
        String file = parts.get(1);
        this.parseDictionary(file);
    }

    private void parseBeginVendor(String line, int lineNumber) {
        List<String> parts = this.parseLine(line);
        if (parts.size() != 2 || this.currentVendor != null) {
            throw new RuntimeException("Syntax error on line " + lineNumber);
        }
        this.currentVendor = parts.get(1);
    }

    private void parseEndVendor(String line, int lineNumber) {
        List<String> parts = this.parseLine(line);
        if (parts.size() != 2 || this.currentVendor == null || !this.currentVendor.equalsIgnoreCase(parts.get(1))) {
            throw new RuntimeException("Syntax error on line " + lineNumber);
        }
        this.currentVendor = null;
    }

    private void parseAttribute(String line, int lineNumber) {
        List<String> parts = this.parseLine(line);
        if (parts.size() < 4) {
            throw new RuntimeException("Syntax error on line " + lineNumber);
        }
        String name = parts.get(1);
        int number = Integer.parseInt(parts.get(2));
        Class<? extends RadiusAttribute> type = this.getAttributeTypeClass(parts.get(3), number);
        if (StringUtils.isEmpty((String)this.currentVendor)) {
            this.addAttributeType(new AttributeType(number, name, type));
        } else {
            int vendor = this.getVendorId(this.currentVendor);
            this.addAttributeType(new AttributeType(vendor, number, name, type));
        }
    }

    private void parseValue(String line, int lineNumber) {
        List<String> parts = this.parseLine(line);
        if (parts.size() != 4) {
            throw new RuntimeException("Syntax error on line " + lineNumber);
        }
        String attributeName = parts.get(1);
        String valueName = parts.get(2);
        int number = Integer.parseInt(parts.get(3));
        AttributeType attributeType = this.getAttributeTypeByName(attributeName);
        if (attributeType == null) {
            throw new RuntimeException("Invalid attribute name on line " + lineNumber);
        }
        attributeType.addEnumerationValue(number, valueName);
    }

    private void parseVendor(String line, int lineNumber) {
        List<String> parts = this.parseLine(line);
        if (parts.size() < 3) {
            throw new RuntimeException("Syntax error on line " + lineNumber);
        }
        String vendorName = parts.get(1);
        int number = Integer.parseInt(parts.get(2));
        this.addVendor(number, vendorName);
    }

    private List<String> parseLine(String line) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : line.split(SEPARATOR_REGEX)) {
            parts.add(part.trim());
        }
        return parts;
    }

    private Class<? extends RadiusAttribute> getAttributeTypeClass(String type, int number) {
        Class<RadiusAttribute> clazz = RadiusAttribute.class;
        if (number == 26) {
            clazz = VendorSpecificAttribute.class;
        } else if (type.equalsIgnoreCase(TYPE_STRING)) {
            clazz = StringAttribute.class;
        } else if (type.equalsIgnoreCase(TYPE_OCTETS)) {
            clazz = RadiusAttribute.class;
        } else if (type.equalsIgnoreCase(TYPE_INTEGER) || type.equalsIgnoreCase(TYPE_DATE)) {
            clazz = IntegerAttribute.class;
        } else if (type.equalsIgnoreCase(TYPE_IPADDR)) {
            clazz = IpAttribute.class;
        }
        return clazz;
    }
}

