/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth.radius;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class RadiusClient {
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final AuthProtocol DEFAULT_AUTH_PROTOCOL = AuthProtocol.PAP;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final String DEFAULT_NAS_IDENTIFIER = "PingFederate";
    private final String host;
    private final String sharedSecret;
    private final int authPort;
    private final String nasIdentifier;
    private final int retryCount;
    private final int timeout;
    private final AuthProtocol authProtocol;

    public RadiusClient(String host, String sharedSecret) {
        this(host, sharedSecret, 1812, DEFAULT_AUTH_PROTOCOL, DEFAULT_NAS_IDENTIFIER, 3, 3000);
    }

    public RadiusClient(String host, String sharedSecret, int authPort, AuthProtocol authProtocol, String nasIdentifier, int retryCount, int timeout) {
        this.host = host;
        this.sharedSecret = sharedSecret;
        this.authPort = authPort;
        this.authProtocol = authProtocol;
        this.nasIdentifier = nasIdentifier;
        this.retryCount = retryCount;
        this.timeout = timeout;
    }

    public String getHost() {
        return this.host;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public AuthProtocol getAuthProtocol() {
        return this.authProtocol;
    }

    public String getNasIdentifier() {
        return this.nasIdentifier;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("Hostname", (Object)this.host);
        builder.append("Auth Port", this.authPort);
        builder.append("Auth Protocol", (Object)this.authProtocol);
        builder.append("NAS Identifier", (Object)this.nasIdentifier);
        builder.append("Retry Count", this.retryCount);
        builder.append("Timeout", this.timeout);
        return builder.toString();
    }

    public static enum AuthProtocol {
        PAP,
        CHAP;

    }
}

