/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth.radius;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.radius.FreeRadiusDictionary;
import org.sourceid.auth.radius.RadiusClient;
import org.sourceid.auth.radius.RadiusResponse;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.StringAttribute;
import org.tinyradius.dictionary.Dictionary;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusException;

public class RadiusClientHelper {
    private static final Log log = LogFactory.getLog(RadiusClientHelper.class);
    public static final int NAS_IP_ADDRESS_TYPE = 4;
    public static final int FILTER_ID_TYPE = 11;
    public static final int REPLY_MESSAGE_ATTRIBUTE_TYPE = 18;
    public static final int STATE_ATTRIBUTE_TYPE = 24;
    public static final int NAS_IDENTIFIER_ATTRIBUTE_TYPE = 32;
    private static final String BIND_ADDRESS = System.getProperty("pf.engine.bind.address");

    private RadiusClientHelper() {
    }

    public static RadiusResponse authenticate(RadiusClient client, String username, String password) throws AdminUserException {
        return RadiusClientHelper.authenticate(client, username, password, null);
    }

    public static RadiusResponse authenticate(RadiusClient client, String username, String password, byte[] state) throws AdminUserException {
        AccessRequest accessRequest = new AccessRequest(username, password);
        accessRequest.setPacketType(1);
        switch (client.getAuthProtocol()) {
            case CHAP: {
                accessRequest.setAuthProtocol("chap");
                break;
            }
            default: {
                accessRequest.setAuthProtocol("pap");
            }
        }
        RadiusAttribute nasIdentifierAttribute = RadiusAttribute.createRadiusAttribute((int)32);
        nasIdentifierAttribute.setAttributeValue(client.getNasIdentifier());
        accessRequest.addAttribute(nasIdentifierAttribute);
        try {
            if (StringUtils.isNotBlank((String)BIND_ADDRESS) && !"0.0.0.0".equals(BIND_ADDRESS) && InetAddress.getByName(BIND_ADDRESS) instanceof Inet4Address) {
                RadiusAttribute nasIpAddressAttribute = RadiusAttribute.createRadiusAttribute((int)4);
                nasIpAddressAttribute.setAttributeValue(BIND_ADDRESS);
                accessRequest.addAttribute(nasIpAddressAttribute);
            }
        }
        catch (UnknownHostException nasIpAddressAttribute) {
            // empty catch block
        }
        if (state != null) {
            RadiusAttribute stateAttribute = new RadiusAttribute(24, state);
            accessRequest.addAttribute(stateAttribute);
        }
        try {
            RadiusPacket response = RadiusClientHelper.toTinyRadiusClient(client).authenticate(accessRequest);
            if (response == null) {
                log.warn((Object)"Radius authentication failed");
                throw new AdminUserException(AdminUserException.Code.RADIUS_AVAILABILITY);
            }
            switch (response.getPacketType()) {
                case 2: {
                    return new RadiusResponse(response);
                }
                case 11: {
                    throw new RadiusAdminUserException(AdminUserException.Code.RADIUS_ACCESS_CHALLENGE, username, RadiusClientHelper.getState(response), RadiusClientHelper.getReplyMessage(response));
                }
                case 3: {
                    throw new RadiusAdminUserException(AdminUserException.Code.RADIUS_ACCESS_REJECT, username, RadiusClientHelper.getState(response), RadiusClientHelper.getReplyMessage(response));
                }
            }
            throw new UnsupportedOperationException("Unsupported response type: " + response.getPacketTypeName());
        }
        catch (IOException | IllegalArgumentException | RadiusException e) {
            log.error((Object)e.getMessage());
            throw new AdminUserException(AdminUserException.Code.RADIUS_AVAILABILITY);
        }
    }

    private static org.tinyradius.util.RadiusClient toTinyRadiusClient(RadiusClient client) {
        org.tinyradius.util.RadiusClient tinyRadiusClient = new org.tinyradius.util.RadiusClient(client.getHost(), client.getSharedSecret()){

            protected RadiusPacket makeRadiusPacket(DatagramPacket packet, RadiusPacket request) throws IOException, RadiusException {
                ByteArrayInputStream in = new ByteArrayInputStream(packet.getData());
                return RadiusPacket.decodeResponsePacket((Dictionary)FreeRadiusDictionary.getInstance(), (InputStream)in, (String)this.getSharedSecret(), (RadiusPacket)request);
            }
        };
        tinyRadiusClient.setAuthPort(client.getAuthPort());
        tinyRadiusClient.setRetryCount(client.getRetryCount());
        try {
            tinyRadiusClient.setSocketTimeout(client.getTimeout());
        }
        catch (SocketException e) {
            log.warn((Object)("error setting socket timeout for client " + client.getHost()), (Throwable)e);
        }
        return tinyRadiusClient;
    }

    private static byte[] getState(RadiusPacket response) {
        byte[] state = null;
        RadiusAttribute stateAttribute = response.getAttribute(24);
        if (stateAttribute != null) {
            state = stateAttribute.getAttributeData();
        }
        return state;
    }

    private static String getReplyMessage(RadiusPacket response) {
        List replyMessageAttributes = response.getAttributes(18);
        StringBuilder sb = new StringBuilder();
        for (StringAttribute replyMessageAttribute : replyMessageAttributes) {
            sb.append(StringUtils.trimToEmpty((String)replyMessageAttribute.getAttributeValue()));
        }
        return sb.toString();
    }
}

