/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.pingidentity.common.util.B64;
import java.io.Serializable;
import java.util.Arrays;
import org.sourceid.common.ByteUtil;

public class Artifact
implements Serializable {
    protected byte[] typecode;
    protected byte[] sourceId;
    protected byte[] messageHandle;
    public static final int TYPE_CODE_LENGTH = 2;
    public static final int SOURCE_ID_LENGTH = 20;
    public static final int MESSAGE_HANDLE_LENGTH = 20;
    private static final int LENGTH = 42;

    protected Artifact(byte[] typecode, byte[] sourceId, byte[] messageHandle) {
        if (typecode.length != 2) {
            String msg = "TypeCode must be 2 bytes.  Was " + typecode.length;
            throw new IllegalArgumentException(msg);
        }
        if (sourceId.length != 20) {
            String msg = "SourceID must be 20 bytes. Was " + sourceId.length;
            throw new IllegalArgumentException(msg);
        }
        if (messageHandle.length != 20) {
            String msg = "MessageHandle must be 20 bytes.  Was " + messageHandle.length;
            throw new IllegalArgumentException(msg);
        }
        this.typecode = typecode;
        this.sourceId = sourceId;
        this.messageHandle = messageHandle;
    }

    public byte[] rawBytes() {
        byte[] alldata = new byte[42];
        int idx = 0;
        System.arraycopy(this.typecode, 0, alldata, idx, 2);
        System.arraycopy(this.sourceId, 0, alldata, idx += 2, 20);
        System.arraycopy(this.messageHandle, 0, alldata, idx += 20, 20);
        return alldata;
    }

    public int getTypeCode() {
        return ByteUtil.getInt(this.typecode);
    }

    public byte[] getTypecodeBytes() {
        return this.typecode;
    }

    public byte[] getSourceId() {
        return this.sourceId;
    }

    public byte[] getMessageHandle() {
        return this.messageHandle;
    }

    public String toString() {
        return B64.encode((byte[])this.rawBytes());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Artifact otherArtifact = (Artifact)other;
        return Arrays.equals(this.rawBytes(), otherArtifact.rawBytes());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static int parseTypeCode(String artifactString) {
        byte[] bytes = Artifact.parseToBytes(artifactString);
        byte[] typecode = new byte[2];
        System.arraycopy(bytes, 0, typecode, 0, 2);
        return ByteUtil.getInt(typecode);
    }

    public static byte[] parseToBytes(String artifactString) {
        byte[] bytes = B64.decodeToBytes((String)artifactString);
        if (bytes == null) {
            throw new IllegalArgumentException("Error parsing artifact - unable to base64 decode: " + artifactString);
        }
        return bytes;
    }

    public static Artifact parse(String artifact) {
        byte[] alldata = Artifact.parseToBytes(artifact);
        if (alldata.length != 42) {
            throw new IllegalArgumentException("Error parsing artifact (" + artifact + ") - expected length of 42 bytes but was " + alldata.length);
        }
        int idx = 0;
        byte[] typecode = new byte[2];
        System.arraycopy(alldata, idx, typecode, 0, 2);
        byte[] sourceId = new byte[20];
        System.arraycopy(alldata, idx += 2, sourceId, 0, 20);
        byte[] messageHandle = new byte[20];
        System.arraycopy(alldata, idx += 20, messageHandle, 0, 20);
        return new Artifact(typecode, sourceId, messageHandle);
    }
}

