/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import java.nio.ByteBuffer;

public class ByteUtil {
    public static final int MAX_TWO_BYTES_UNSIGNED = 65535;
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static int getInt(byte[] arr) {
        if (arr.length > 4) {
            throw new IllegalArgumentException("Byte array cannot have more than four bytes.");
        }
        byte[] copy = new byte[4];
        for (int i = 0; i < arr.length; ++i) {
            copy[4 - arr.length + i] = arr[i];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(copy);
        byteBuffer.rewind();
        return byteBuffer.getInt();
    }

    public static byte[] getTwoBytes(int intValue) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(intValue);
        byte[] bytes = byteBuffer.array();
        if (bytes[0] != 0 || bytes[1] != 0) {
            throw new IllegalArgumentException("Integer value (" + intValue + ") too large to stuff into two bytes.");
        }
        return new byte[]{bytes[2], bytes[3]};
    }

    public static byte[] getFourBytes(int intValue) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(intValue);
        byte[] bytes = byteBuffer.array();
        return new byte[]{bytes[0], bytes[1], bytes[2], bytes[3]};
    }

    public static boolean secureEquals(byte[] bytes1, byte[] bytes2) {
        bytes1 = bytes1 == null ? EMPTY_BYTES : bytes1;
        bytes2 = bytes2 == null ? EMPTY_BYTES : bytes2;
        int shortest = Math.min(bytes1.length, bytes2.length);
        int longest = Math.max(bytes1.length, bytes2.length);
        int result = 0;
        for (int i = 0; i < shortest; ++i) {
            result |= bytes1[i] ^ bytes2[i];
        }
        return result == 0 && shortest == longest;
    }
}

