/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IDGenerator {
    private static ThreadLocalRandom threadLocalRandom = new ThreadLocalRandom();
    public static final String LOWER_STR = "abcdefghijklmnopqrstuvwxyz";
    public static final char[] LOWER = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final String UPPER_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final char[] UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final String ALPHAS_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMERICS_STR = "0123456789";
    public static final String SPECIAL_CHAR_STRING = "!#$%&()*+,.:;<=>?@";
    public static final String ALPHA_NUMERICS_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final char[] ALPHA_NUMERICS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    public static final String LOWER_ALPHA_NUMERICS_STR = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final char[] LOWER_ALPHA_NUMERICS = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final String ALPHA_NUMERICS_SPECIAL_CHAR_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$%&()*+,.:;<=>?@";
    private static final Log log = LogFactory.getLog(IDGenerator.class);

    public static String rndAlpha(int length) {
        return IDGenerator.rndStr(length, ALPHAS_STR.toCharArray());
    }

    public static String rndNumeric(int length) {
        return IDGenerator.rndStr(length, NUMERICS_STR.toCharArray());
    }

    public static String rndAlphaNumeric(int length) {
        return IDGenerator.rndStr(length, ALPHA_NUMERICS);
    }

    public static String rndAlphaNumericSpecialChars(int length, String includeChars) {
        if (StringUtils.isEmpty((String)includeChars)) {
            includeChars = ALPHA_NUMERICS_SPECIAL_CHAR_STR;
        }
        return IDGenerator.rndStr(length, includeChars.toCharArray());
    }

    public static String rndStr(int length, char[] fromChars) {
        Random random = (Random)threadLocalRandom.get();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int rnd = random.nextInt(fromChars.length);
            chars[i] = fromChars[rnd];
        }
        return new String(chars);
    }

    public static String rndGroupedNumeric(int groupLength, int numGroups) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < numGroups; ++i) {
            stringBuilder.append(IDGenerator.rndNumeric(groupLength));
            if (i >= numGroups - 1) continue;
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public static byte[] generateBytes(int length) {
        Random random = (Random)threadLocalRandom.get();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String generateBase64UrlEncodedBytes(int numberOfBytes) {
        byte[] bytes = IDGenerator.generateBytes(numberOfBytes);
        return Base64URL.encodeToString((byte[])bytes);
    }

    private static class ThreadLocalRandom
    extends ThreadLocal<Random> {
        private ThreadLocalRandom() {
        }

        @Override
        protected Random initialValue() {
            return SecurityProviderUtil.getSecureRandom();
        }
    }
}

