/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.sourceid.common.Util;

public class PFVelocityResourceLoader
extends FileResourceLoader {
    private static final String[] SEARCH_LIST = new String[]{"$velocityCount", "$velocityHasNext"};
    private static final String[] REPLACEMENT_LIST = new String[]{"$foreach.count", "$foreach.hasNext"};

    public Reader getResourceReader(String templateName, String encoding) throws ResourceNotFoundException {
        Reader reader = super.getResourceReader(templateName, encoding);
        return this.performReplacements(reader);
    }

    protected Reader performReplacements(Reader reader) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufReader = new BufferedReader(reader);){
            String line;
            while ((line = bufReader.readLine()) != null) {
                String result = StringUtils.replaceEachRepeatedly((String)line, (String[])SEARCH_LIST, (String[])REPLACEMENT_LIST);
                sb.append(result).append(Util.LINE_BREAK);
            }
        }
        catch (IOException e) {
            throw new ResourceNotFoundException("Error performing velocity predefined reference replacement", (Throwable)e);
        }
        return new StringReader(sb.toString());
    }
}

