/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.pingidentity.common.util.EscapeUtils;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.locale.LocaleUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.common.VelocityTemplateUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;

public class ResponseTemplateRenderer {
    public static final String VAR_NAME_BASE = "var";
    private static final String TEMPLATE_DIR = "template";
    private static final Logger log = LoggerFactory.getLogger(ResponseTemplateRenderer.class);
    private static final ResponseTemplateRenderer instance = new ResponseTemplateRenderer();
    private final EscapeUtils escapeUtils = new EscapeUtils();
    private final VelocityTemplateUtils velocityTemplateUtils = new VelocityTemplateUtils();

    private ResponseTemplateRenderer() {
        try {
            SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
            String confDir = sysDirInfo.getConfigDirectory();
            Properties props = VelocityTemplateUtils.getVelocityProperties(confDir + File.separator + TEMPLATE_DIR);
            Velocity.init((Properties)props);
        }
        catch (Exception ex) {
            log.error("Unable to initialize Velocity.", (Throwable)ex);
        }
    }

    public static ResponseTemplateRenderer getInstance() {
        return instance;
    }

    @Deprecated
    public void render(HttpServletResponse resp, String templateFile, Map<String, Object> params) throws ResponseTemplateRendererException {
        this.render(null, resp, templateFile, params);
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, String templateFile, Map<String, Object> params) throws ResponseTemplateRendererException {
        this.render(req, resp, templateFile, params, "text/html", true);
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, String templateFile, Map<String, Object> params, String contentType, boolean addTrackingId) throws ResponseTemplateRendererException {
        Object baseUrl;
        Map<String, Object> templateParams = this.mergeDefaultParams(params, req);
        VelocityContext context = new VelocityContext(templateParams, VelocityTemplateUtils.getVelocityToolContext());
        context.put("utils", (Object)this.velocityTemplateUtils);
        context.put("escape", (Object)this.escapeUtils);
        context.put("HttpServletResponse", (Object)resp);
        context.put("HttpServletRequest", (Object)req);
        String transactionId = TransactionIdSupport.getTransactionId();
        context.put("TransactionId", (Object)transactionId);
        if (addTrackingId) {
            String trackingId = TrackingIdSupport.generateTrackingId(req, resp);
            context.put("TrackingId", (Object)trackingId);
        }
        if (StringUtils.isNotBlank((String)(baseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl())) && !((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        context.put("PingFedBaseURL", baseUrl);
        String currentBaseUrl = BaseUrlUtil.getCurrentBaseUrl((String)baseUrl);
        context.put("CurrentPingFedBaseURL", (Object)currentBaseUrl);
        Locale userLocale = LocaleUtil.getUserLocale(req);
        context.put("locale", (Object)userLocale);
        context.put("templateMessages", (Object)LocaleUtil.getLanguagePackMessagesForHtmlTemplates(userLocale));
        int CSP_NONCE_LENGTH = 16;
        context.put("CSPNonce", (Object)IDGenerator.rndAlphaNumeric(CSP_NONCE_LENGTH));
        resp.setCharacterEncoding("UTF-8");
        try (PrintWriter writer = null;){
            Template template = Velocity.getTemplate((String)templateFile, (String)"UTF-8");
            writer = resp.getWriter();
            resp.setContentType(contentType);
            if (template != null) {
                template.merge((Context)context, (Writer)writer);
            }
            if (writer != null && writer.checkError()) {
                String msg = "Unable to render the template due to errors in response writer." + this.getTemplateFileName(templateFile);
                throw new IOException(msg);
            }
        }
    }

    private String getTemplateFileName(String templateFile) {
        Object path = Velocity.getProperty((String)"resource.loader.file.path");
        return path + File.separator + templateFile;
    }

    public void renderResponse(HttpServletRequest req, HttpServletResponse resp, ContentTemplate contentTemplate) throws IOException {
        String templateName = contentTemplate.getTemplateName();
        Object[] args = contentTemplate.getArguments();
        HashMap<String, Object> params = new HashMap<String, Object>();
        int numArgs = args.length;
        for (int i = 0; i < numArgs; ++i) {
            params.put(VAR_NAME_BASE + i, args[i]);
        }
        try {
            this.render(req, resp, templateName, params);
        }
        catch (ResponseTemplateRendererException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    Map<String, Object> mergeDefaultParams(Map<String, Object> params, HttpServletRequest req) {
        Object defaultParamsObj = req != null ? req.getAttribute("defaultTemplateParams") : null;
        Map defaultParams = new HashMap();
        if (defaultParamsObj instanceof Map) {
            defaultParams = (Map)defaultParamsObj;
        }
        for (Map.Entry entry : defaultParams.entrySet()) {
            Object paramValue;
            String key = (String)entry.getKey();
            Object defaultValue = entry.getValue();
            if (!params.containsKey(key) || defaultValue.equals(paramValue = params.get(key))) continue;
            log.debug("Overwriting default template parameter '{}' with the value provided by this plugin - default value:'{}', plugin value:'{}'", new Object[]{key, defaultValue, paramValue});
        }
        HashMap<String, Object> mergedParams = new HashMap<String, Object>(defaultParams);
        mergedParams.putAll(params);
        return mergedParams;
    }

    public static abstract class ContentTemplate {
        private final String templateName;

        protected ContentTemplate(String templateName) {
            this.templateName = templateName;
        }

        public abstract Object[] getArguments();

        public String getTemplateName() {
            return this.templateName;
        }
    }
}

