/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.dsig;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.crypto.SignatureAlgorithms;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.common.dsig.VerificationException;

public class QueryStringSignatureUtil {
    private static final Log log = LogFactory.getLog(QueryStringSignatureUtil.class);
    private static final BouncyCastleFipsProvider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();
    public static final String SIG_ALG_PARAM = "SigAlg";
    public static final String SIGNATURE_PARAM = "Signature";
    public static final String SIG_ALG = "&SigAlg=";
    public static final String SIGNATURE = "&Signature=";
    static final String DSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    static final String RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    static final String ECDSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";

    public static SignatureStatus verifyQuerySignature(String query, PublicKey key) throws VerificationException {
        String sigAlg = SIG_ALG_PARAM;
        int sigAlgPos = query.lastIndexOf(sigAlg);
        int signaturePos = query.lastIndexOf(SIGNATURE);
        if (sigAlgPos < 0 || signaturePos < 0) {
            return SignatureStatus.NOT_PRESENT;
        }
        if (key == null) {
            return SignatureStatus.UNVERIFIED;
        }
        String unsignedQuery = query.substring(0, signaturePos);
        int algoBeginIndex = sigAlg.length() + sigAlgPos + 1;
        int andIndex = query.indexOf("&", algoBeginIndex + 1);
        String algo = query.substring(algoBeginIndex, andIndex);
        String signature_str = query.substring(signaturePos + SIGNATURE.length());
        try {
            Signature verifier;
            algo = URLDecoder.decode(algo, "UTF-8");
            signature_str = URLDecoder.decode(signature_str, "UTF-8");
            byte[] signature = B64.decodeToBytes((String)signature_str);
            String algName = SignatureAlgorithms.getInstance().algUriToNameForRuntime(algo);
            if (algName == null) {
                log.info((Object)("Unknown signature algorithm : " + LogGuard.encode(algo)));
                return SignatureStatus.INVALID;
            }
            if (algName.contains("withRSA") && !key.getAlgorithm().equals("RSA")) {
                log.info((Object)("Key mismatch on query string signature: query = " + LogGuard.encode(query) + ", RSA, " + key.getAlgorithm()));
                return SignatureStatus.INVALID;
            }
            if (algName.endsWith("withDSA") && !key.getAlgorithm().equals("DSA")) {
                log.info((Object)("Key mismatch on query string signature: query = " + LogGuard.encode(query) + ", DSA, " + key.getAlgorithm()));
                return SignatureStatus.INVALID;
            }
            if (algName.endsWith("withECDSA") && !key.getAlgorithm().equals("EC")) {
                log.info((Object)("Key mismatch on query string signature: query = " + LogGuard.encode(query) + ", EC, " + key.getAlgorithm()));
                return SignatureStatus.INVALID;
            }
            if (SignatureAlgorithms.RSASSA_PSS_ALGORITHM_ID_LIST.stream().anyMatch(algName::equalsIgnoreCase)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using Bouncy Castle FIPS provider for RSASSA-PSS algorithm Id: " + algName));
                }
                verifier = Signature.getInstance(algName, (Provider)bouncyCastleFipsProvider);
            } else {
                verifier = Signature.getInstance(algName);
            }
            verifier.initVerify(key);
            verifier.update(unsignedQuery.getBytes("UTF-8"));
            boolean isValid = verifier.verify(signature);
            return isValid ? SignatureStatus.VALID : SignatureStatus.INVALID;
        }
        catch (SignatureException se) {
            log.info((Object)("Invalid signature: " + se.getMessage()));
            return SignatureStatus.INVALID;
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    public static SignedQuery signQuery(String query, PrivateKey key, String signatureAlgorithm) throws SigningException {
        SignedQuery signedQueryObj = new SignedQuery();
        StringBuilder signedQuery = new StringBuilder();
        signedQuery.append(query);
        signedQuery.append(SIG_ALG);
        try {
            Signature signer;
            String algName;
            if (StringUtils.isNotEmpty((String)signatureAlgorithm)) {
                algName = SignatureAlgorithms.getInstance().algUriToNameForRuntime(signatureAlgorithm);
                if (algName == null) {
                    throw new SigningException("Signing key uses an unknown algorithm: " + signatureAlgorithm);
                }
                signedQueryObj.algo = signatureAlgorithm;
            } else {
                String algorithm = key.getAlgorithm();
                if ("RSA".equals(algorithm)) {
                    algName = "SHA1withRSA";
                    signedQueryObj.algo = RSA_SHA1;
                } else if ("DSA".equals(algorithm)) {
                    algName = "SHA1withDSA";
                    signedQueryObj.algo = DSA_SHA1;
                } else if ("EC".equals(algorithm)) {
                    algName = "SHA256withECDSA";
                    signedQueryObj.algo = ECDSA_SHA256;
                } else {
                    throw new SigningException("Signing key uses an unknown algorithm: " + algorithm);
                }
            }
            String hsmProviderName = SecurityProviderUtil.getHSMProviderName(key);
            if (hsmProviderName != null) {
                signer = Signature.getInstance(algName, hsmProviderName);
            } else if (SignatureAlgorithms.RSASSA_PSS_ALGORITHM_ID_LIST.stream().anyMatch(algName::equalsIgnoreCase)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using Bouncy Castle FIPS provider for RSASSA-PSS algorithm Id: " + algName));
                }
                signer = Signature.getInstance(algName, (Provider)bouncyCastleFipsProvider);
            } else {
                signer = Signature.getInstance(algName);
            }
            signedQuery.append(URLEncoder.encode(signedQueryObj.algo, "UTF-8"));
            signer.initSign(key);
            signer.update(signedQuery.toString().getBytes("UTF-8"));
            byte[] signature = signer.sign();
            String signatureStr = B64.encode((byte[])signature);
            signedQuery.append(SIGNATURE);
            signedQuery.append(URLEncoder.encode(signatureStr, "UTF-8"));
            signedQueryObj.signature = signatureStr;
        }
        catch (SigningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SigningException("Error generating signature.", e);
        }
        signedQueryObj.signedQueryString = signedQuery.toString();
        return signedQueryObj;
    }

    public static class NormalizedQueryString {
        private String queryString;
        private boolean hasSignature;

        public NormalizedQueryString(String queryString, boolean hasSignature) {
            this.queryString = queryString;
            this.hasSignature = hasSignature;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public boolean hasSignature() {
            return this.hasSignature;
        }
    }

    public static class SignedQuery {
        private String signedQueryString;
        private String signature;
        private String algo;

        public String getSignedQueryString() {
            return this.signedQueryString;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getAlgo() {
            return this.algo;
        }
    }
}

