/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.json;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.json.JsonUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;

public class SimpleJsonRespWriter {
    public static final String CONTENT_TYPE = "application/json";

    public void writeJson(HttpServletResponse resp, Map<String, ?> content) throws IOException {
        this.prepHeaders(resp);
        PrintWriter writer = resp.getWriter();
        JsonUtil.writeJson(content, (Writer)writer);
        this.finish(resp);
    }

    public void finish(HttpServletResponse resp) throws IOException {
        resp.getWriter().write(new char[]{'\r', '\n'});
        resp.flushBuffer();
    }

    public void prepHeaders(HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType(CONTENT_TYPE);
    }

    public static void prepareAttributeMap(AttributeMap attributes, Map<String, Object> targetMap) {
        SimpleJsonRespWriter.prepareAttributeMap(attributes, targetMap, Collections.emptyList());
    }

    public static void prepareAttributeMap(AttributeMap attributes, Map<String, Object> targetMap, List<String> attributeContractCollections) {
        for (Map.Entry e : attributes.entrySet()) {
            String key = (String)e.getKey();
            AttributeValue v = (AttributeValue)e.getValue();
            if (v == null || key == null) continue;
            SimpleJsonRespWriter.setForJsonSerialize(targetMap, key, v, attributeContractCollections);
        }
    }

    public static void setForJsonSerialize(Map<String, Object> targetMap, String key, AttributeValue v) {
        targetMap.put(key, v.isMultiValue() ? SimpleJsonRespWriter.getList(v) : SimpleJsonRespWriter.getSingleValue(v.getObjectValue(), v.getValue()));
    }

    public static void setForJsonSerialize(Map<String, Object> targetMap, String key, AttributeValue v, Collection<String> attributeContractCollections) {
        Object value = v.isMultiValue() || attributeContractCollections != null && attributeContractCollections.contains(key) ? SimpleJsonRespWriter.getList(v) : SimpleJsonRespWriter.getSingleValue(v.getObjectValue(), v.getValue());
        targetMap.put(key, value);
    }

    private static Object getList(AttributeValue value) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterable objectValues = value.getAllObjectValues();
        Iterable stringValues = value.getValues();
        if (objectValues != null && stringValues != null) {
            Iterator objectIterator = objectValues.iterator();
            Iterator stringIterator = stringValues.iterator();
            while (objectIterator.hasNext() && stringIterator.hasNext()) {
                list.add(SimpleJsonRespWriter.getSingleValue(objectIterator.next(), (String)stringIterator.next()));
            }
        }
        return list;
    }

    private static Object getSingleValue(Object objValue, String strValue) {
        if (objValue instanceof byte[]) {
            return strValue;
        }
        return objValue;
    }
}

